/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;
import org.apache.lucene.analysis.kr.utils.EomiUtil;
import org.apache.lucene.analysis.kr.utils.IrregularUtil;
import org.apache.lucene.analysis.kr.utils.MorphUtil;

public class VerbUtil {
    public static final Map verbSuffix = new HashMap();
    public static final Map XVerb = new HashMap();

    static {
        String[] suffixs = new String[]{"\uc774", "\ud558", "\ub418", "\ub0b4", "\uc2a4\ub7fd", "\uc2dc\ud0a4", "\uc788", "\uc5c6", "\uac19", "\ub2f9\ud558", "\ub9cc\ud558", "\ub4dc\ub9ac", "\ubc1b", "\uc9d3"};
        int i = 0;
        while (i < suffixs.length) {
            verbSuffix.put(suffixs[i], suffixs[i]);
            ++i;
        }
        String[] xverbs = new String[]{"\uc624", "\ub0b4", "\uc8fc", "\ubcf4", "\uc9c0", "\uc624\ub974", "\uc62c\ub9ac"};
        int i2 = 0;
        while (i2 < xverbs.length) {
            XVerb.put(xverbs[i2], xverbs[i2]);
            ++i2;
        }
    }

    public static int endsWithVerbSuffix(String stem) {
        int len = stem.length();
        if (len < 2) {
            return -1;
        }
        int start = 2;
        if (len == 2) {
            start = 1;
        }
        int i = start;
        while (i > 0) {
            if (verbSuffix.get(stem.substring(len - i)) != null) {
                return len - i;
            }
            --i;
        }
        return -1;
    }

    public static int endsWithXVerb(String stem) {
        int len = stem.length();
        if (len < 2) {
            return -1;
        }
        int start = 2;
        if (len == 2) {
            start = 1;
        }
        int i = start;
        while (i > 0) {
            if (XVerb.get(stem.substring(len - i)) != null) {
                return len - i;
            }
            --i;
        }
        return -1;
    }

    public static boolean verbSuffix(String stem) {
        return verbSuffix.get(stem) != null;
    }

    public static boolean constraintVerb(String start, String end) {
        char[] schs = MorphUtil.decompose(start.charAt(start.length() - 1));
        char[] echs = MorphUtil.decompose(end.charAt(0));
        return schs.length != 3 || schs[2] != '\u3139' || echs[0] != '\u3139';
    }

    public static boolean ananlysisNJCM(AnalysisOutput o, List candidates) throws MorphException {
        int strlen = o.getStem().length();
        boolean success = false;
        if (strlen > 3 && (o.getStem().endsWith("\uc5d0\uc11c\uc774") || o.getStem().endsWith("\ubd80\ud130\uc774"))) {
            o.addElist(o.getStem().substring(strlen - 1));
            o.setJosa(o.getStem().substring(strlen - 3, strlen - 1));
            o.setStem(o.getStem().substring(0, strlen - 3));
            success = true;
        } else if (strlen > 5 && o.getStem().endsWith("\uc5d0\uc11c\ubd80\ud130\uc774")) {
            o.addElist(o.getStem().substring(strlen - 1));
            o.setJosa(o.getStem().substring(strlen - 5, strlen - 1));
            o.setStem(o.getStem().substring(0, strlen - 5));
            success = true;
        }
        if (!success) {
            return false;
        }
        if (success && DictionaryUtil.getNoun(o.getStem()) != null) {
            o.setScore(100);
        }
        o.setPatn(6);
        o.setPos('N');
        candidates.add(o);
        return true;
    }

    public static boolean ananlysisNSM(AnalysisOutput o, List candidates) throws MorphException {
        int idxVbSfix;
        if (o.getStem().endsWith("\uc2a4\ub7ec\uc6b0")) {
            o.setStem(String.valueOf(o.getStem().substring(0, o.getStem().length() - 3)) + "\uc2a4\ub7fd");
        }
        if ((idxVbSfix = VerbUtil.endsWithVerbSuffix(o.getStem())) < 1) {
            return false;
        }
        o.setVsfx(o.getStem().substring(idxVbSfix));
        o.setStem(o.getStem().substring(0, idxVbSfix));
        o.setPatn(3);
        o.setPos('N');
        WordEntry entry = DictionaryUtil.getWordExceptVerb(o.getStem());
        if (entry != null) {
            if (entry.getFeature(0) == '0') {
                return false;
            }
            if (o.getVsfx().equals("\ud558") && entry.getFeature(3) != '1') {
                return false;
            }
            if (o.getVsfx().equals("\ub418") && entry.getFeature(4) != '1') {
                return false;
            }
            if (o.getVsfx().equals("\ub0b4") && entry.getFeature(5) != '1') {
                return false;
            }
            o.setScore(100);
        } else {
            o.setScore(30);
        }
        candidates.add(o);
        return true;
    }

    public static boolean ananlysisNSMXM(AnalysisOutput o, List candidates) throws MorphException {
        int idxXVerb = VerbUtil.endsWithXVerb(o.getStem());
        if (idxXVerb == -1) {
            return false;
        }
        String eogan = o.getStem().substring(0, idxXVerb);
        String[] stomis = null;
        stomis = (eogan.endsWith("\uc544") || eogan.endsWith("\uc5b4")) && eogan.length() > 1 ? EomiUtil.splitEomi(eogan.substring(0, eogan.length() - 1), eogan.substring(eogan.length() - 1)) : EomiUtil.splitEomi(eogan, "");
        if (stomis[0] == null) {
            return false;
        }
        o.addElist(stomis[1]);
        int idxVbSfix = VerbUtil.endsWithVerbSuffix(stomis[0]);
        if (idxVbSfix == -1) {
            return false;
        }
        o.setXverb(o.getStem().substring(idxXVerb));
        o.setVsfx(stomis[0].substring(idxVbSfix));
        o.setStem(stomis[0].substring(0, idxVbSfix));
        o.setPatn(5);
        o.setPos('N');
        WordEntry entry = DictionaryUtil.getNoun(o.getStem());
        if (entry == null) {
            return false;
        }
        if (o.getVsfx().equals("\ud558") && entry.getFeature(3) != '1') {
            return false;
        }
        if (o.getVsfx().equals("\ub418") && entry.getFeature(4) != '1') {
            return false;
        }
        o.setScore(100);
        candidates.add(o);
        return true;
    }

    public static boolean analysisVMCM(AnalysisOutput o, List candidates) throws MorphException {
        int strlen = o.getStem().length();
        if (strlen < 2) {
            return false;
        }
        if (!o.getStem().endsWith("\uc774")) {
            return false;
        }
        char[] chrs = MorphUtil.decompose(o.getStem().charAt(strlen - 2));
        boolean success = false;
        if (strlen > 2 && o.getStem().endsWith("\uae30\uc774")) {
            o.setStem(o.getStem().substring(0, strlen - 2));
            o.addElist("\uae30");
            success = true;
        } else if (chrs.length > 2 && chrs[2] == '\u3141') {
            String[] eres = EomiUtil.splitEomi(o.getStem().substring(0, strlen - 1), "");
            if (eres[0] == null) {
                return false;
            }
            o.addElist(eres[1]);
            String[] irrs = IrregularUtil.restoreIrregularVerb(eres[0], eres[1]);
            if (irrs != null) {
                o.setStem(irrs[0]);
            } else {
                o.setStem(eres[0]);
            }
            success = true;
        }
        if (success) {
            o.addElist("\uc774");
            if (DictionaryUtil.getVerb(o.getStem()) != null) {
                o.setPos('V');
                o.setPatn(13);
                o.setScore(100);
                candidates.add(o);
                return true;
            }
        }
        return false;
    }

    public static boolean analysisVMXM(AnalysisOutput o, List candidates) throws MorphException {
        int idxXVerb = VerbUtil.endsWithXVerb(o.getStem());
        if (idxXVerb == -1) {
            return false;
        }
        o.setXverb(o.getStem().substring(idxXVerb));
        String eogan = o.getStem().substring(0, idxXVerb);
        String[] stomis = null;
        if (eogan.endsWith("\uc544") || eogan.endsWith("\uc5b4") ? (stomis = EomiUtil.splitEomi(eogan.substring(0, eogan.length() - 1), eogan.substring(eogan.length() - 1)))[0] == null : (stomis = EomiUtil.splitEomi(eogan, ""))[0] == null || !stomis[1].startsWith("\uc544") && !stomis[1].startsWith("\uc5b4")) {
            return false;
        }
        String[] irrs = IrregularUtil.restoreIrregularVerb(stomis[0], stomis[1]);
        if (irrs != null) {
            o.setStem(irrs[0]);
            o.addElist(irrs[1]);
        } else {
            o.setStem(stomis[0]);
            o.addElist(stomis[1]);
        }
        if (DictionaryUtil.getVerb(o.getStem()) != null) {
            o.setPos('V');
            o.setPatn(14);
            o.setScore(100);
            candidates.add(o);
            return true;
        }
        return false;
    }
}

