% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devianceKspm.R
\name{deviance.kspm}
\alias{deviance.kspm}
\title{Model deviance}
\usage{
\method{deviance}{kspm}(object, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}, for which the deviance is desired.}

\item{...}{additional optional argument (currently unused).}
}
\value{
The value of the deviance extracted from the object \code{object}.
}
\description{
Returns the deviance of a fitted model object of class "kspm".
}
\details{
This function extracts deviance of a model fitted using \code{kspm} function. The returned deviance is the residual sum of square (RSS).
}
\examples{
x <- 1:15
y <- 3*x + rnorm(15, 0, 2)
fit <- kspm(y, kernel = ~ Kernel(x, kernel.function = "linear"))
deviance(fit)

}
\seealso{
\link{kspm}, \link{extractAIC.kspm}
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
