% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signals.R
\name{signal}
\alias{signal}
\title{Extracting the Partial Signal Of a State Space Model}
\usage{
signal(object, states = "all", filtered = FALSE)
}
\arguments{
\item{object}{Object of class \code{KFS}.}

\item{states}{Which states are combined? Either a numeric vector containing
the indices of the corresponding states, or a character vector defining the
types of the corresponding states. Possible choices are
 \code{"all"},  \code{"level"}, \code{"slope"},
 \code{"trend"},  \code{"regression"}, \code{"arima"}, \code{"custom"},
 \code{"cycle"} or \code{"seasonal"}, where \code{"trend"} extracts states relating to trend.
  These can be combined. Default is \code{"all"}.}

\item{filtered}{If \code{TRUE}, filtered signal is used. Otherwise smoothed signal is
used.}
}
\value{
\item{signal}{Time series object of filtered signal \eqn{Z_ta_t}{Z[t]a[t]} or
smoothed signal \eqn{Z_t\hat\alpha_t}{Z[t]\alpha[t]} using only the defined states. }
\item{variance}{Cov(\eqn{Z_ta_t}{Z[t]a[t]}) or Cov(\eqn{Z_t\hat\alpha_t}{Z[t]\alpha[t]}) using only the defined states.
For the covariance matrices of the filtered signal, only the non-diffuse part of P is used.  }
}
\description{
Function \code{signal} returns the signal of a state space model using only
subset of states.
}
\examples{
model <- SSModel(log(drivers) ~ SSMtrend(1, NA) +
    SSMseasonal(12, sea.type = 'trigonometric', Q = NA) +
    log(PetrolPrice) + law,data = Seatbelts, H = NA)

ownupdatefn <- function(pars,model,...){
  model$H[] <- exp(pars[1])
  diag(model$Q[,,1]) <- exp(c(pars[2], rep(pars[3], 11)))
  model
}

fit <- fitSSM(inits = log(c(var(log(Seatbelts[,'drivers'])), 0.001, 0.0001)),
  model = model, updatefn = ownupdatefn, method = 'BFGS')

out <- KFS(fit$model, smoothing = c('state', 'mean'))
ts.plot(cbind(out$model$y, fitted(out)),lty = 1:2, col = 1:2,
  main = 'Observations and smoothed signal with and without seasonal component')
lines(signal(out, states = c('regression', 'trend'))$signal, col = 4, lty = 1)
legend('bottomleft',
  legend = c('Observations', 'Smoothed signal','Smoothed level'),
  col = c(1, 2, 4), lty = c(1, 2, 1))

}

