% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Polar2Rec.R
\name{Polar2Rec}
\alias{Polar2Rec}
\title{Polar to rectangular coordinates}
\usage{
Polar2Rec(R, Theta)
}
\arguments{
\item{R}{The length of \code{X}.}

\item{Theta}{A vector of length \code{d-1}, containing the angles of \code{X}.}
}
\value{
A list of the following:
\item{X}{A vector in rectangular coordinate.}
\item{V}{The directional vector of \code{X}. Note that \code{V} is always on
the unit sphere.}
}
\description{
Given a polar coordinate representation \code{(R,Theta)} of a
\code{d}-dimensional vector \code{X}, where \code{R} is the length of
\code{X} and the \code{(d-1)}-dimensional vector \code{Theta} contains the
\code{d-1} angles of \code{X}, this function compute \code{X} in its
rectangular coordinate representation.
}
\details{
The formula corresponds to v=rho(theta) as in Lemma 1 of Tang and Li (2024).
See also Anderson (2003).
Note that when \code{d=2}, \code{V} will be \code{(sin(Theta),cos(Theta))}.
}
\examples{
R=2
Theta=c(pi/6,pi/3)
Polar2Rec(R,Theta)

}
\references{
\cite{Tang, Y. and Li, B. (2024), “A nonparametric test for elliptical
distribution based on kernel embedding of probabilities,”
\url{https://arxiv.org/abs/2306.10594}}
\cite{Anderson, T. W. (2003). An Introduction to Multivariate Statistical
Analysis. John Wiley & Suns, Inc. Huboken, New Jersey.}
}
