% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsim.R
\name{SV2F}
\alias{SV2F}
\title{SV2F model simulation}
\usage{
SV2F(M, m, p.0 = 3, mu = 0.03, v.1 = 0.5, v.2 = 0.5,
  beta.0 = -1.2, beta.1 = 0.04, beta.2 = 1.5, alpha.1 = -0.137 *
  exp(-2), alpha.2 = -1.386, beta.v2 = 0.25, r1 = -0.3, r2 = -0.3)
}
\arguments{
\item{M}{number of interverals to be simulated}

\item{m}{number of time points within each interval}

\item{p.0}{start price}

\item{mu}{drift}

\item{v.1}{volatility parameter}

\item{v.2}{volatility parameter}

\item{beta.0}{underlying Brownian motion intercept paramter}

\item{beta.1}{underlying Brownian motion slope parameter}

\item{beta.2}{underlying Brownian motion slope parameter}

\item{alpha.1}{volatility parameter}

\item{alpha.2}{volatility parameter}

\item{beta.v2}{second factor Brownian motion slope parameter}

\item{r1}{correlation to first factor}

\item{r2}{correlation to second factor}
}
\value{
simulated time series
}
\description{
Simulate Stochastic Volitility model with two factors model (no jump) with given length and other parameters
}
\examples{
SV2F(1000,390)
}
\references{
Chernov, M., et al. (2003). "Alternative models for stock price dynamics." Journal of Econometrics 116(1): 225-257.
}
