% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_brain.R
\name{plot_brain}
\alias{plot_brain}
\title{plot 3d brain network from JointNets result}
\usage{
plot_brain(x, ...)
}
\arguments{
\item{x}{output generated from any one of the JointNets functions}

\item{...}{additional arguments, please see \code{\link{plot_brain.simule}}, \code{\link{plot_brain.wsimule}} and etc for details}
}
\value{
3d (rgl) brain network
}
\description{
This function plots 3d brain network from JointNets result
}
\details{
The function plots brain network using \code{\link{rglplot.igraph}}
}
\examples{
library(JointNets)
graphics.off()
par(ask=FALSE)
par(mfrow=c(1,1))
data(ABIDE_aal116_timeseries)
data(aal116coordinates)
layout = cbind(aal116coordinates$x.mni + 90,
aal116coordinates$y.mni+126, aal116coordinates$z.mni+72)
result = simulation(p=116, s = 0.001, ss = 0.001, n = c(1,1))$simulatedgraphs
class(result) = "simule"
plot_brain(result, type = "task", neighbouroption = "task",
subID = NULL, index = NULL, layout = layout, hasbackground = FALSE)
\donttest{
result = simule(ABIDE_aal116_timeseries, 0.2, 1, covType = "cov", FALSE)
plot_brain(result, type = "task", neighbouroption = "task",
subID = NULL, index = NULL, layout = layout)
}
}
\author{
Zhaoyang Wang (Author), Zhaoyang Wang (maintainer) \email{zw4dn@virginia.edu}
}
