\name{Johnson-package}
\alias{Johnson-package}
\alias{Johnson}
\docType{package}
\title{Johnson transformation}
\description{Johnson transform to normality using the Z family of distributions. Performs the Johnson Transformation based on the method of the percentiles.
Include the Anderson-Darling Test
}
\details{
The values of the Johnson Transformation Function can be obtained
\tabular{ll}{
Package: \tab Johnson\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2011-04-25\cr
License: \tab What license is it under?\cr
LazyLoad: \tab yes\cr
}

}
\author{Edgar Santos Fernandez

Maintainer: Edgar Santos Fernandez <edgar.santos@etecsa.cu>}

\references{
Chou, Youn Min; Polansky, A. M. M. R. L. (1998), "Transforming non normal data to normality in
statistical process control", Journal of Quality Technology 30, 2, April.

Johnson, N. L. (1949), "Systems of Frequency Curves Generated by Methods of Translation". URL:
http://www.jstor.org/stable/2332539

Slifker, J. F. & Shapiro, S. S. (1980), "The johnson system: selection and parameter estimation",
Technometrics 22(2).

Trujillo-Ortiz, A., R. H.-W. K. B.-R. & Castro-Perez., A.(2007), 
"Andartest:anderson-darling test for assessing
normality of a sample data.".
URL: http://www.mathworks.com/matlabcentral/fileexchange/loadFile.do?objectId=14807



}

\keyword{ package }
\seealso{
<pkg>
}
\examples{
# transforming to normality a random sample with beta distribution
x<-rbeta(30,2,3)
y<-RE.Johnson(x);print(y)

# working with the transformed variable
x<-runif(100)
y<-RE.Johnson(x)$transformed;print(y)

# working with the p-values
x<-rgamma(100,2,1)
y<-RE.Johnson(x)$p;print(y)
}
