/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Language;

import antlr.collections.AST;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Databases.EvaluationFrame;
import org.omegahat.Environment.Databases.ReadWriteDatabase;
import org.omegahat.Environment.Databases.ReadWriteDatabaseInt;
import org.omegahat.Environment.Databases.TypedDatabase;
import org.omegahat.Environment.Interpreter.BasicEvaluator;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Language.Evaluable;
import org.omegahat.Environment.Language.Signature;
import org.omegahat.Environment.Parser.Parse.AssignExpression;
import org.omegahat.Environment.Parser.Parse.Comment;
import org.omegahat.Environment.Parser.Parse.ControlFlowException;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.List;
import org.omegahat.Environment.Parser.Parse.LocalVariable;
import org.omegahat.Environment.Parser.Parse.MethodDefinition;
import org.omegahat.Environment.Parser.Parse.MethodParameter;
import org.omegahat.Environment.Parser.Parse.Name;
import org.omegahat.Environment.Parser.Parse.StatementList;
import org.omegahat.Environment.System.Globals;
import org.omegahat.Environment.Utils.OrderedTable;

public class Function
implements Evaluable,
Serializable {
    public static final Object MissingArgument = "Missing Function Argument";
    public static final String OptionalArgumentsVariableName = "...";
    public static final String OptionalArgumentVariablePrefix = "$";
    protected Evaluable body = null;
    protected Vector exceptions = null;
    protected Class returnType;
    protected Database templateFrame = null;
    protected Vector argumentNames = null;
    protected String name = "<Unknown function name>";
    protected boolean hasVariableArguments = false;
    protected String documentation;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public Function() {
    }

    public Function(ExpressionInt expressionInt, List list2, Name name, List list3, String string, Evaluator evaluator) throws ClassNotFoundException {
        this.body(expressionInt);
        this.argList(list2, evaluator);
        this.exceptions(list3, evaluator);
        if (name != null) {
            try {
                this.returnType((Class)name.eval(evaluator));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Throwable throwable) {
                System.err.println("Problem resolving return type class " + name);
            }
        }
        this.name(string);
    }

    public Function(MethodDefinition methodDefinition) {
    }

    public String addArgument(AssignExpression assignExpression) throws ClassNotFoundException {
        return this.addArgument(assignExpression, null);
    }

    public String addArgument(AssignExpression assignExpression, Evaluator evaluator) throws ClassNotFoundException {
        Object object = assignExpression.element(1);
        return this.addArgument((MethodParameter)assignExpression.element(0), object, evaluator);
    }

    public String addArgument(MethodParameter methodParameter) throws ClassNotFoundException {
        return this.addArgument(methodParameter, "Missing Function Argument");
    }

    public String addArgument(MethodParameter methodParameter, Object object) throws ClassNotFoundException {
        return this.addArgument(methodParameter, object, null);
    }

    public String addArgument(MethodParameter methodParameter, Object object, Evaluator evaluator) throws ClassNotFoundException {
        Database database = this.argList();
        String string = methodParameter.name();
        if (database.exists(string = this.addArgumentName(string))) {
            System.err.println("Duplicate argument names (" + string + ") in function definition.");
        }
        try {
            database.assign(string, object);
        }
        catch (Exception exception) {
            Globals.warning("can't assign default value of parameter " + string);
        }
        if (methodParameter.type() != null) {
            if (evaluator != null) {
                try {
                    Class clazz = (Class)methodParameter.type().eval(evaluator);
                    ((TypedDatabase)database).setType(string, clazz);
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    ((TypedDatabase)database).setType(string, methodParameter.type());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Globals.warning("Class of argument " + string + " not currently locatable.");
                }
            }
        }
        if (methodParameter.isFinal()) {
            ((ReadWriteDatabaseInt)((Object)database)).readOnly(string, methodParameter.isFinal());
        }
        return string;
    }

    public String addArgument(MethodParameter methodParameter, Evaluator evaluator) throws ClassNotFoundException {
        return this.addArgument(methodParameter, "Missing Function Argument", evaluator);
    }

    public String addArgumentName(String string) {
        Vector vector2 = this.argumentNames();
        if (vector2 == null) {
            vector2 = this.argumentNames(new Vector(1));
        }
        if (string.equals(OptionalArgumentsVariableName)) {
            this.hasVariableArguments(true);
            string = OptionalArgumentsVariableName;
        }
        if (vector2.contains(string)) {
            Globals.warning("Duplicate argument name " + string);
        } else {
            vector2.addElement(string);
        }
        return string;
    }

    public Database argList() {
        if (this.templateFrame == null) {
            this.argList(new EvaluationFrame("function argument frame for " + this.name()));
        }
        return this.templateFrame;
    }

    public Database argList(Database database) {
        this.templateFrame = database;
        return this.argList();
    }

    public Database argList(List list2, Evaluator evaluator) throws ClassNotFoundException {
        if (list2 == null) {
            return this.argList();
        }
        Enumeration enumeration = list2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof MethodParameter) {
                this.addArgument((MethodParameter)e, evaluator);
                continue;
            }
            if (!(e instanceof AssignExpression)) continue;
            this.addArgument((AssignExpression)e, evaluator);
        }
        return this.argList();
    }

    public String argumentName(int n) {
        String string = null;
        Vector vector2 = this.argumentNames();
        if (n >= vector2.size()) {
            if (this.hasVariableArguments()) {
                string = OptionalArgumentVariablePrefix + (n - vector2.size() + 1);
            }
        } else {
            string = (String)vector2.elementAt(n);
        }
        return string;
    }

    public Vector argumentNames() {
        return this.argumentNames;
    }

    public Vector argumentNames(Vector vector2) {
        this.argumentNames = vector2;
        return this.argumentNames();
    }

    public Object assignArgument(Database database, Object object, String string, String string2, Evaluator evaluator) throws Throwable {
        if (!this.lazy(evaluator) && object instanceof ExpressionInt) {
            object = ((ExpressionInt)object).eval(evaluator);
        }
        database.assign(string, object);
        return object;
    }

    public Object assignNamedArgument(Database database, AssignExpression assignExpression, String string, String string2, Evaluator evaluator) throws Throwable {
        Database database2 = assignExpression.database(database);
        Object object = assignExpression.eval(evaluator);
        assignExpression.database(database2);
        return object;
    }

    public Evaluable body() {
        return this.body;
    }

    public Evaluable body(Evaluable evaluable) {
        this.body = evaluable;
        return this.body();
    }

    public Evaluable body(StatementList statementList) {
        return this.body((Evaluable)statementList);
    }

    public Database callFrame(Evaluator evaluator) throws Throwable {
        Database database = this.frame(evaluator);
        return database;
    }

    public boolean checkReturnType(Object object, Evaluator evaluator) {
        boolean bl = true;
        if (object == null) {
            return bl;
        }
        if (this.returnType() != null) {
            Class<?> clazz = object.getClass();
            Class clazz2 = this.returnType();
            bl = BasicEvaluator.isPrimitive(clazz2) ? (clazz2 == Boolean.TYPE ? clazz == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = Function.class$("java.lang.Boolean"))) : (clazz2 == Integer.TYPE ? clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Function.class$("java.lang.Integer"))) : (clazz2 == Double.TYPE ? clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = Function.class$("java.lang.Double"))) : (clazz2 == Long.TYPE ? clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = Function.class$("java.lang.Long"))) : (clazz2 == Float.TYPE ? clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = Function.class$("java.lang.Float"))) : (clazz2 == Short.TYPE ? clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = Function.class$("java.lang.Short"))) : (clazz2 == Byte.TYPE ? clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = Function.class$("java.lang.Byte"))) : (clazz2 == Character.TYPE ? clazz == (class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = Function.class$("java.lang.Character"))) : false)))))))) : clazz2.isAssignableFrom(clazz);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Database createCallFrame(Evaluator evaluator) {
        return new EvaluationFrame("Call frame for " + this.name());
    }

    public int createVariable(LocalVariable localVariable, Database database, Evaluator evaluator) throws Throwable {
        Database database2 = localVariable.database(database);
        localVariable.eval(evaluator);
        localVariable.database(database2);
        return localVariable.elements().size();
    }

    public Object eval(Object object, Evaluator evaluator) throws Throwable {
        return this.eval(this.matchArguments(new List(object), evaluator), evaluator);
    }

    public Object eval(Database database, Evaluator evaluator) throws Throwable {
        return this.eval(database, true, evaluator);
    }

    public Object eval(Database database, boolean bl, Evaluator evaluator) throws Throwable {
        evaluator.attach(database, 0);
        Object object = null;
        try {
            block10: {
                try {
                    if (this.isSynchronized()) {
                        Function function = this;
                        synchronized (function) {
                            object = this.evalBody(evaluator);
                            break block10;
                        }
                    }
                    object = this.evalBody(evaluator);
                }
                catch (ControlFlowException controlFlowException) {
                    if (controlFlowException.type() == 42) {
                        object = controlFlowException.value();
                    }
                    throw controlFlowException;
                }
            }
            Object var6_7 = null;
            evaluator.detach(database);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            evaluator.detach(database);
            throw throwable;
        }
        if (!this.checkReturnType(object, evaluator)) {
            evaluator.warning("Inconsistent return value for function " + this.returnType());
        }
        return object;
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        return this.eval(this.frame(evaluator), false, evaluator);
    }

    public Object eval(List list2, Evaluator evaluator) throws Throwable {
        Database database = this.matchArguments(list2, evaluator);
        return this.eval(database, false, evaluator);
    }

    public Object eval(Object[] objectArray, Evaluator evaluator) throws Throwable {
        int n = objectArray == null ? 0 : objectArray.length;
        List list2 = new List();
        int n2 = 0;
        while (n2 < n) {
            list2.addElement(objectArray[n2]);
            ++n2;
        }
        Database database = this.matchArguments(list2, evaluator);
        return this.eval(database, false, evaluator);
    }

    public Object evalBody(Evaluator evaluator) throws Throwable {
        List list2;
        Object object = null;
        if (this.body() != null && (list2 = (List)this.body().eval(evaluator)) != null && list2.size() > 0) {
            object = list2.elementAt(list2.size() - 1);
        }
        return object;
    }

    public Vector exceptions() {
        return this.exceptions;
    }

    public Vector exceptions(Vector vector2) {
        this.exceptions = vector2;
        return this.exceptions();
    }

    public Vector exceptions(List list2, Evaluator evaluator) throws ClassNotFoundException {
        if (list2 == null) {
            return null;
        }
        Vector<Class> vector2 = new Vector<Class>(list2.size());
        Enumeration enumeration = list2.elements();
        while (enumeration.hasMoreElements()) {
            Name name = (Name)enumeration.nextElement();
            vector2.addElement(evaluator.findClass(name));
        }
        return this.exceptions(vector2);
    }

    protected Database frame(Evaluator evaluator) throws Throwable {
        Database database = this.argList();
        TypedDatabase typedDatabase = (TypedDatabase)this.createCallFrame(evaluator);
        String[] stringArray = database.objects();
        Vector vector2 = ((ReadWriteDatabase)database).permissions();
        Vector vector3 = new Vector(vector2.size());
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector3.addElement(enumeration.nextElement());
        }
        typedDatabase.permissions(vector3);
        int n = 0;
        while (n < stringArray.length) {
            Object object = database.get(stringArray[n]);
            if (object instanceof Evaluable) {
                object = this.templateArgument((Evaluable)object, stringArray[n], evaluator);
            }
            typedDatabase.assign(stringArray[n], object);
            Class clazz = ((TypedDatabase)database).type(stringArray[n]);
            if (clazz != null) {
                typedDatabase.setType(stringArray[n], clazz);
            }
            ++n;
        }
        return typedDatabase;
    }

    public String functionName(Evaluator evaluator) {
        return this.name();
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public AST getFirstChild() {
        return (AST)this.body();
    }

    public boolean hasVariableArguments() {
        return this.hasVariableArguments;
    }

    public boolean hasVariableArguments(boolean bl) {
        this.hasVariableArguments = bl;
        return this.hasVariableArguments();
    }

    public boolean isSynchronized() {
        return false;
    }

    public boolean lazy(Evaluator evaluator) {
        return false;
    }

    public int matchArgument(Database database, Object object, Vector vector2, int n, Evaluator evaluator) throws Throwable {
        Object object2;
        String string;
        AssignExpression assignExpression = null;
        String string2 = null;
        boolean bl = false;
        if (object instanceof AssignExpression) {
            assignExpression = (AssignExpression)object;
            string = assignExpression.getName(evaluator);
            if (!database.exists(string)) {
                bl = true;
                string2 = string;
                n = vector2.indexOf(OptionalArgumentsVariableName);
            } else {
                n = vector2.indexOf(string) + 1;
            }
        } else if ((string = this.argumentName(n++)).startsWith(OptionalArgumentVariablePrefix)) {
            bl = true;
            string2 = string;
        }
        if (string == null || !database.exists(string) && !this.hasVariableArguments()) {
            throw new Exception("No argument " + string + " in call to " + this.functionName(evaluator));
        }
        OrderedTable orderedTable = null;
        if (string.equals(OptionalArgumentsVariableName) || bl) {
            object2 = OptionalArgumentsVariableName;
            Object object3 = database.get((String)object2);
            if (object3 instanceof OrderedTable) {
                orderedTable = (OrderedTable)object3;
            }
            if (database == null || "Missing Function Argument".equals(object3)) {
                orderedTable = new OrderedTable(3);
                database.assign((String)object2, orderedTable);
            }
            if (assignExpression == null) {
                string = string2 = OptionalArgumentVariablePrefix + orderedTable.size();
            }
        }
        object2 = null;
        object2 = assignExpression != null ? this.assignNamedArgument(database, assignExpression, string, string2, evaluator) : this.assignArgument(database, object, string, string2, evaluator);
        if (string2 != null && orderedTable instanceof OrderedTable && object2 != null) {
            orderedTable.put(string2, object2);
        }
        return n;
    }

    public Database matchArguments(Database database, List list2, Evaluator evaluator) throws Throwable {
        if (list2 != null && list2.size() > 0) {
            if (!this.hasVariableArguments() && database.size() < list2.size()) {
                throw new Exception("Too many arguments to function `" + this.functionName(evaluator) + "'");
            }
            int n = list2.size();
            int n2 = 0;
            Vector vector2 = this.argumentNames();
            int n3 = 0;
            while (n3 < n) {
                Object object = list2.elementAt(n3);
                n2 = this.matchArgument(database, object, vector2, n2, evaluator);
                ++n3;
            }
        }
        return database;
    }

    public Database matchArguments(List list2, Evaluator evaluator) throws Throwable {
        Database database = this.callFrame(evaluator);
        database = this.matchArguments(database, list2, evaluator);
        return database;
    }

    public String name() {
        return this.name;
    }

    public String name(String string) {
        this.name = string;
        return this.name();
    }

    public Class[] parameterTypes() {
        Vector vector2 = this.argumentNames();
        if (vector2 == null || vector2.size() == 0) {
            return null;
        }
        int n = vector2.size();
        Class[] classArray = new Class[n];
        TypedDatabase typedDatabase = (TypedDatabase)this.argList();
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = typedDatabase.type((String)vector2.elementAt(n2));
            if (classArray[n2] == null) {
                classArray[n2] = class$java$lang$Object != null ? class$java$lang$Object : Function.class$("java.lang.Object");
            }
            ++n2;
        }
        return classArray;
    }

    public Class returnType() {
        return this.returnType;
    }

    public Class returnType(Class clazz) {
        this.returnType = clazz;
        return this.returnType();
    }

    public String setDocumentation(String string) {
        this.documentation = string;
        return this.getDocumentation();
    }

    public String setDocumentation(Comment comment) {
        return this.setDocumentation(comment.text());
    }

    public StringBuffer showArg(String string, Database database, StringBuffer stringBuffer) {
        Object object;
        if (database instanceof TypedDatabase && (object = ((TypedDatabase)database).type(string)) != null) {
            stringBuffer.append(((Class)object).getName());
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        object = database.get(string);
        if (object != "Missing Function Argument") {
            stringBuffer.append(" = ");
            stringBuffer.append(database.get(string));
        }
        return stringBuffer;
    }

    public String showArguments() {
        return this.showArguments(new StringBuffer(100));
    }

    public String showArguments(StringBuffer stringBuffer) {
        Database database = this.argList();
        if (database.size() < 1) {
            return stringBuffer.toString();
        }
        Vector vector2 = this.argumentNames();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            this.showArg((String)vector2.elementAt(n2), database, stringBuffer);
            if (n2 < n - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Signature signature() {
        TypedDatabase typedDatabase = (TypedDatabase)this.argList();
        Signature signature = new Signature(this.returnType());
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            Enumeration enumeration = this.argumentNames().elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                Class<?> clazz2 = typedDatabase.type((String)e);
                if (clazz2 == null) {
                    clazz2 = clazz;
                }
                signature.put((String)e, clazz2);
            }
        }
        catch (Exception exception) {}
        return signature;
    }

    public Object templateArgument(Evaluable evaluable, String string, Evaluator evaluator) throws Throwable {
        return evaluable.eval(evaluator);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("function");
        if (this.name() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.name());
        }
        stringBuffer.append("(");
        stringBuffer.append(this.showArguments());
        stringBuffer.append(")");
        stringBuffer.append(" -> ");
        stringBuffer.append(this.returnType() == null ? "java.lang.Object" : this.returnType().getName());
        stringBuffer.append("\n");
        stringBuffer.append(this.body());
        return stringBuffer.toString();
    }
}

