/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.AlternativeBlock;
import antlr.ExceptionSpec;
import antlr.Grammar;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.ParserGrammar;
import antlr.RuleEndElement;
import antlr.Token;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.collections.impl.Vector;
import java.util.Hashtable;

public class RuleBlock
extends AlternativeBlock {
    protected String ruleName;
    protected String argAction;
    protected String returnAction;
    protected RuleEndElement endNode;
    protected boolean testLiterals = false;
    Vector labeledElements;
    protected boolean[] lock;
    protected Lookahead[] cache;
    Hashtable exceptionSpecs;
    protected boolean defaultErrorHandler = true;
    protected String ignoreRule;

    public RuleBlock(Grammar grammar, String string) {
        super(grammar);
        this.ruleName = string;
        this.labeledElements = new Vector();
        this.cache = new Lookahead[grammar.maxk + 1];
        this.exceptionSpecs = new Hashtable();
        this.setAutoGen(grammar instanceof ParserGrammar);
    }

    public RuleBlock(Grammar grammar, String string, int n, boolean bl) {
        this(grammar, string);
        this.line = n;
        this.setAutoGen(bl);
    }

    public void addExceptionSpec(ExceptionSpec exceptionSpec) {
        if (this.findExceptionSpec(exceptionSpec.label) != null) {
            if (exceptionSpec.label != null) {
                this.grammar.tool.error("Rule '" + this.ruleName + "' already has an exception handler for label: " + exceptionSpec.label);
                return;
            }
            this.grammar.tool.error("Rule '" + this.ruleName + "' already has an exception handler");
            return;
        }
        this.exceptionSpecs.put(exceptionSpec.label == null ? "" : exceptionSpec.label.getText(), exceptionSpec);
    }

    public ExceptionSpec findExceptionSpec(Token token) {
        return (ExceptionSpec)this.exceptionSpecs.get(token == null ? "" : token.getText());
    }

    public ExceptionSpec findExceptionSpec(String string) {
        return (ExceptionSpec)this.exceptionSpecs.get(string == null ? "" : string);
    }

    public void generate() {
        this.grammar.generator.gen(this);
    }

    public boolean getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public RuleEndElement getEndElement() {
        return this.endNode;
    }

    public String getIgnoreRule() {
        return this.ignoreRule;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public boolean getTestLiterals() {
        return this.testLiterals;
    }

    public boolean isLexerAutoGenRule() {
        return this.ruleName.equals("nextToken");
    }

    public Lookahead look(int n) {
        return this.grammar.theLLkAnalyzer.look(n, this);
    }

    public void prepareForAnalysis() {
        super.prepareForAnalysis();
        this.lock = new boolean[this.grammar.maxk + 1];
    }

    public void setDefaultErrorHandler(boolean bl) {
        this.defaultErrorHandler = bl;
    }

    public void setEndElement(RuleEndElement ruleEndElement) {
        this.endNode = ruleEndElement;
    }

    public void setOption(Token token, Token token2) {
        if (token.getText().equals("defaultErrorHandler")) {
            if (token2.getText().equals("true")) {
                this.defaultErrorHandler = true;
                return;
            }
            if (token2.getText().equals("false")) {
                this.defaultErrorHandler = false;
                return;
            }
            this.grammar.tool.error("Value for defaultErrorHandler must be true or false", token.getLine());
            return;
        }
        if (token.getText().equals("testLiterals")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.tool.error("testLiterals option only valid for lexer rules", token.getLine());
                return;
            }
            if (token2.getText().equals("true")) {
                this.testLiterals = true;
                return;
            }
            if (token2.getText().equals("false")) {
                this.testLiterals = false;
                return;
            }
            this.grammar.tool.error("Value for testLiterals must be true or false", token.getLine());
            return;
        }
        if (token.getText().equals("ignore")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.tool.error("ignore option only valid for lexer rules", token.getLine());
                return;
            }
            this.ignoreRule = token2.getText();
            return;
        }
        if (token.getText().equals("paraphrase")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.tool.error("paraphrase option only valid for lexer rules", token.getLine());
                return;
            }
            TokenSymbol tokenSymbol = this.grammar.tokenManager.getTokenSymbol(this.ruleName);
            if (tokenSymbol == null) {
                Tool.panic("cannot find token associated with rule " + this.ruleName);
            }
            tokenSymbol.setParaphrase(token2.getText());
            return;
        }
        this.grammar.tool.error("Invalid rule option: " + token.getText(), token.getLine());
    }

    public String toString() {
        return String.valueOf(this.ruleName) + ": " + super.toString() + " ;";
    }
}

