% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_assumptions.R
\name{plot_assumptions}
\alias{plot_assumptions}
\title{Returns diagnostic plots for the linear model used in a mediation}
\usage{
plot_assumptions(
  mediation_model,
  tests = c("normality", "heteroscedasticity", "outliers")
)
}
\arguments{
\item{mediation_model}{An object of class \code{mediation_model}.}

\item{tests}{A character vector indicating which test to run. Supported test
includes \code{"normality"}, \code{"heteroscedasticity"}, and
\code{"outliers"}}
}
\value{
Invisibly returns an object of class \code{mediation_model}.
}
\description{
When conducting a joint-significant test, different models are
fitted to the data. This function returns diagnostic plots for each of the
model used in the mediation model. \code{check_assumptions_plot} uses the
\code{performance} and \code{see} packages behind the scenes to provide the different
plots.

This function is best used in an interactive context.
}
\examples{
data(ho_et_al)
ho_et_al$condition_c <- build_contrast(ho_et_al$condition,
                                       "Low discrimination",
                                       "High discrimination")
my_model <-
  mdt_simple(data = ho_et_al,
             IV = condition_c,
             DV = hypodescent,
             M = linkedfate)

plot_assumptions(my_model)

}
\seealso{
Other assumption checks: 
\code{\link{check_assumptions}()}
}
\concept{assumption checks}
