\name{JOPS}
\alias{JOPS}
\alias{JOPS-package}
\docType{package}

\title{Joys of P-Splines}

\description{A package for working with and learning about P-splines. P-splines combine B-splines with discrete penalties to build a very flexible and effective smooth models. They can handle non-normal data in the style of generalized linear models.

This package provides functions for constructing B-spline bases and penalty matrices. It solves the penalized likelihood equations efficiently.

Several methods are provided to determine the values of penalty  parameters automatically, using cross-validation, AIC, mixed models or fast Bayesian algorithms.

This package is a companion to the book by Eilers and Marx (2021). The book presents the underlying theory and contains many examples and the code \code{R} for each example is available on the website \url{https://psplines.bitbucket.io}

}

\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C. and Marx, B.D. (1996). Flexible smoothing with
B-splines and penalties (with comments and rejoinder),
\emph{Statistical Science}, 11: 89-121.
}
