/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.TxtTableLoader;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.ExtensionFileFilter;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.util.ErrorMsg;

public class DataLoader
extends JFrame
implements PropertyChangeListener {
    private static String[][] extensions = new String[][]{{"rda", "rdata"}, {"robj"}, {"csv"}, {"txt"}, {"sav"}, {"xpt"}, {"dbf"}, {"dta"}, {"syd", "sys"}, {"arff"}, {"rec"}, {"mtp"}, {"s3"}};
    private static String[] extensionDescription = new String[]{"R (*.rda *.rdata)", "R dput() (*.robj)", "Comma seperated (*.csv)", "Text file (*.txt)", "SPSS (*.sav)", "SAS export (*.xpt)", "DBase (*.dbf)", "Stata (*.dta)", "Systat (*.sys *.syd)", "ARFF (*.arff)", "Epiinfo (*.rec)", "Minitab (*.mtp)", "S data dump (*.s3)"};
    private JTextField rDataNameField;
    private String rName;
    private FileSelector fileDialog;
    private boolean nameAccepted = false;

    public DataLoader() {
        try {
            this.fileDialog = new FileSelector(this, "Load Data", 0, null, true);
            JFileChooser jFileChooser = this.fileDialog.getJFileChooser();
            for (int i = 0; i < extensionDescription.length; ++i) {
                ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(extensionDescription[i], extensions[i]);
                jFileChooser.addChoosableFileFilter(extensionFileFilter);
            }
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new JLabel("Set name: "));
            this.rDataNameField = new JTextField(20);
            jPanel.add(this.rDataNameField);
            this.fileDialog.addFooterPanel(jPanel);
            this.fileDialog.getJFileChooser().addPropertyChangeListener(this);
            this.fileDialog.setVisible(true);
            if (this.fileDialog.getFile() == null) {
                return;
            }
            String string = this.fileDialog.getDirectory() + this.fileDialog.getFile();
            this.rName = this.rDataNameField.getText();
            if (this.rName.length() == 0) {
                this.rName = this.fileDialog.getFile().indexOf(".") <= 0 ? JGR.MAINRCONSOLE.getUniqueName(this.fileDialog.getFile()) : JGR.MAINRCONSOLE.getUniqueName(this.fileDialog.getFile().substring(0, this.fileDialog.getFile().indexOf(".")));
            }
            this.rName = RController.makeValidVariableName(this.rName);
            this.loadData(this.fileDialog.getFile(), this.fileDialog.getDirectory(), this.rName);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void loadData(String string, String string2, String string3) {
        if (string.toLowerCase().endsWith(".rda") || string.toLowerCase().endsWith(".rdata")) {
            this.loadRdaFile(string, string2);
        } else if (string.toLowerCase().endsWith(".robj")) {
            this.loadDputFile(string, string2);
        } else if (string.toLowerCase().endsWith(".r")) {
            Editor editor = new Editor((string2 + string).replace('\\', '/'), true);
            editor.dispose();
        } else if (string.toLowerCase().endsWith(".txt") | string.toLowerCase().endsWith(".csv")) {
            this.loadTxtFile(string, string2, string3);
        } else {
            try {
                RController.loadPackage("foreign");
                if (string.toLowerCase().endsWith(".sav")) {
                    JGR.MAINRCONSOLE.executeLater(string3 + " <- as.data.frame(read.spss('" + (string2 + string).replace('\\', '/') + "'))", true);
                } else if (string.toLowerCase().endsWith(".xpt") | string.toLowerCase().endsWith(".xport")) {
                    JGR.MAINRCONSOLE.executeLater(string3 + " <- read.xport('" + (string2 + string).replace('\\', '/') + "')", true);
                } else if (string.toLowerCase().endsWith(".dta")) {
                    JGR.MAINRCONSOLE.executeLater(string3 + " <- read.dta('" + (string2 + string).replace('\\', '/') + "')", true);
                } else if (string.toLowerCase().endsWith(".arff")) {
                    JGR.MAINRCONSOLE.executeLater(string3 + " <- read.arff('" + (string2 + string).replace('\\', '/') + "')", true);
                } else if (string.toLowerCase().endsWith(".rec")) {
                    JGR.MAINRCONSOLE.executeLater(string3 + " <- read.epiinfo('" + (string2 + string).replace('\\', '/') + "')", true);
                } else if (string.toLowerCase().endsWith(".mtp")) {
                    JGR.MAINRCONSOLE.executeLater(string3 + " <- as.data.frame(read.mtp('" + (string2 + string).replace('\\', '/') + "'))", true);
                } else if (string.toLowerCase().endsWith(".s3")) {
                    JGR.MAINRCONSOLE.executeLater("data.restore('" + (string2 + string).replace('\\', '/') + "',print=TRUE)", true);
                } else if (string.toLowerCase().endsWith(".syd") || string.toLowerCase().endsWith(".sys")) {
                    JGR.MAINRCONSOLE.executeLater(string3 + " <- read.systat('" + (string2 + string).replace('\\', '/') + "')", true);
                } else if (string.toLowerCase().endsWith(".dbf")) {
                    JGR.MAINRCONSOLE.executeLater(string3 + " <- read.dbf('" + (string2 + string).replace('\\', '/') + "')", true);
                } else {
                    int n = JOptionPane.showConfirmDialog(this, "Unknown File Type.\nWould you like to try to open it as a text data file?");
                    if (n == 0) {
                        this.loadTxtFile(string, string2, string3);
                    }
                }
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        }
    }

    public void loadRdaFile(String string, String string2) {
        String string3 = "print(load(\"" + (string2 + string).replace('\\', '/') + "\"))";
        JGR.R.eval("cat('The following data objects have been loaded:\\\n')", false);
        JGR.MAINRCONSOLE.executeLater(string3, true);
    }

    public void loadDputFile(String string, String string2) {
        String string3 = string.indexOf(".") <= 0 ? JGR.MAINRCONSOLE.getUniqueName(string) : JGR.MAINRCONSOLE.getUniqueName(string.substring(0, string.indexOf(".")));
        JGR.MAINRCONSOLE.executeLater(string3 + " <- dget('" + (string2 + string).replace('\\', '/') + "')", true);
    }

    public void loadTxtFile(String string, String string2, String string3) {
        TxtTableLoader.run(string2 + string, string3);
    }

    public String getDataName() {
        return this.rName;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        File file = this.fileDialog.getSelectedFile();
        if (!(file == null || file.isDirectory() || file.getName().toLowerCase().endsWith(".rdata") || file.getName().toLowerCase().endsWith(".rda"))) {
            String string = file.getName().replaceAll("\\..*", "");
            string = JGR.MAINRCONSOLE.getUniqueName(string);
            this.rDataNameField.setText(string);
        } else {
            this.rDataNameField.setText("");
        }
    }
}

