/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;

public class TextTransferHandler
extends TransferHandler
implements UIResource {
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private int p0;
    private int p1;
    static /* synthetic */ Class class$java$lang$String;

    protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        DataFlavor dataFlavor3 = null;
        if (jTextComponent instanceof JEditorPane) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                String string = dataFlavorArray[i].getMimeType();
                if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) {
                    return dataFlavorArray[i];
                }
                if (dataFlavor == null && string.startsWith("text/plain")) {
                    dataFlavor = dataFlavorArray[i];
                    continue;
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == (class$java$lang$String == null ? TextTransferHandler.class$("java.lang.String") : class$java$lang$String)) {
                    dataFlavor2 = dataFlavorArray[i];
                    continue;
                }
                if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                dataFlavor3 = dataFlavorArray[i];
            }
            if (dataFlavor != null) {
                return dataFlavor;
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            String string = dataFlavorArray[i].getMimeType();
            if (string.startsWith("text/plain")) {
                return dataFlavorArray[i];
            }
            if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == (class$java$lang$String == null ? TextTransferHandler.class$("java.lang.String") : class$java$lang$String)) {
                dataFlavor2 = dataFlavorArray[i];
                continue;
            }
            if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
            dataFlavor3 = dataFlavorArray[i];
        }
        if (dataFlavor2 != null) {
            return dataFlavor2;
        }
        if (dataFlavor3 != null) {
            return dataFlavor3;
        }
        return null;
    }

    protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl) throws BadLocationException, IOException {
        if (bl) {
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            int n3 = n2 - n;
            EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
            Document document = jTextComponent.getDocument();
            if (n3 > 0) {
                document.remove(n, n3);
            }
            editorKit.read(reader, document, n);
        } else {
            int n;
            char[] cArray = new char[1024];
            boolean bl2 = false;
            StringBuffer stringBuffer = null;
            while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n);
                }
                int n4 = 0;
                block5: for (int i = 0; i < n; ++i) {
                    switch (cArray[i]) {
                        case '\r': {
                            if (bl2) {
                                if (i == 0) {
                                    stringBuffer.append('\n');
                                    continue block5;
                                }
                                cArray[i - 1] = 10;
                                continue block5;
                            }
                            bl2 = true;
                            continue block5;
                        }
                        case '\n': {
                            if (!bl2) continue block5;
                            if (i > n4 + 1) {
                                stringBuffer.append(cArray, n4, i - n4 - 1);
                            }
                            bl2 = false;
                            n4 = i;
                            continue block5;
                        }
                        default: {
                            if (!bl2) continue block5;
                            if (i == 0) {
                                stringBuffer.append('\n');
                            } else {
                                cArray[i - 1] = 10;
                            }
                            bl2 = false;
                        }
                    }
                }
                if (n4 >= n) continue;
                if (bl2) {
                    if (n4 >= n - 1) continue;
                    stringBuffer.append(cArray, n4, n - n4 - 1);
                    continue;
                }
                stringBuffer.append(cArray, n4, n - n4);
            }
            if (bl2) {
                stringBuffer.append('\n');
            }
            jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
        }
    }

    public int getSourceActions(JComponent jComponent) {
        if (jComponent instanceof JPasswordField && jComponent.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            return 0;
        }
        return ((JTextComponent)jComponent).isEditable() ? 1 : 1;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        this.exportComp = (JTextComponent)jComponent;
        this.shouldRemove = true;
        this.p0 = this.exportComp.getSelectionStart();
        this.p1 = this.exportComp.getSelectionEnd();
        String string = null;
        try {
            string = this.exportComp.getText(this.p0, this.p1 - this.p0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.p0 != this.p1 && string != null ? new StringSelection(string) : null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.shouldRemove && n == 2) {
            try {
                ((JTextComponent)jComponent).replaceSelection("");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.exportComp = null;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (jTextComponent == this.exportComp && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
            this.shouldRemove = false;
            return true;
        }
        boolean bl = false;
        DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
        if (dataFlavor != null) {
            try {
                Object object;
                boolean bl2 = false;
                if (jComponent instanceof JEditorPane && !((JEditorPane)(object = (JEditorPane)jComponent)).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                    bl2 = true;
                }
                if ((object = jTextComponent.getInputContext()) != null) {
                    ((InputContext)object).endComposition();
                }
                Reader reader = dataFlavor.getReaderForText(transferable);
                this.handleReaderImport(reader, jTextComponent, bl2);
                bl = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
            return false;
        }
        return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
    }
}

