% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochron.R
\name{isochron}
\alias{isochron}
\alias{isochron.default}
\alias{isochron.ArAr}
\alias{isochron.KCa}
\alias{isochron.PbPb}
\alias{isochron.RbSr}
\alias{isochron.ReOs}
\alias{isochron.SmNd}
\alias{isochron.LuHf}
\alias{isochron.ThU}
\alias{isochron.UThHe}
\title{Calculate and plot isochrons}
\usage{
isochron(x, ...)

\method{isochron}{default}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA, clabel = "",
  ellipse.col = c("#00FF0080", "#FF000080"), ci.col = "gray80",
  line.col = "black", lwd = 1, plot = TRUE, title = TRUE,
  model = 1, xlab = "x", ylab = "y", ...)

\method{isochron}{ArAr}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA, clabel = "",
  ellipse.col = c("#00FF0080", "#FF000080"), inverse = TRUE,
  ci.col = "gray80", line.col = "black", lwd = 1, plot = TRUE,
  exterr = TRUE, model = 1, ...)

\method{isochron}{KCa}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA, clabel = "",
  ellipse.col = c("#00FF0080", "#FF000080"), ci.col = "gray80",
  line.col = "black", lwd = 1, plot = TRUE, exterr = TRUE,
  model = 1, ...)

\method{isochron}{PbPb}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA, clabel = "",
  ellipse.col = c("#00FF0080", "#FF000080"), inverse = TRUE,
  ci.col = "gray80", line.col = "black", lwd = 1, plot = TRUE,
  exterr = TRUE, model = 1, growth = FALSE, ...)

\method{isochron}{RbSr}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA, clabel = "",
  ellipse.col = c("#00FF0080", "#FF000080"), ci.col = "gray80",
  line.col = "black", lwd = 1, plot = TRUE, exterr = TRUE,
  model = 1, ...)

\method{isochron}{ReOs}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA, clabel = "",
  ellipse.col = c("#00FF0080", "#FF000080"), ci.col = "gray80",
  line.col = "black", lwd = 1, plot = TRUE, exterr = TRUE,
  model = 1, ...)

\method{isochron}{SmNd}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA, clabel = "",
  ellipse.col = c("#00FF0080", "#FF000080"), ci.col = "gray80",
  line.col = "black", lwd = 1, plot = TRUE, exterr = TRUE,
  model = 1, ...)

\method{isochron}{LuHf}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, levels = NA, clabel = "",
  ellipse.col = c("#00FF0080", "#FF000080"), ci.col = "gray80",
  line.col = "black", lwd = 1, plot = TRUE, exterr = TRUE,
  model = 1, ...)

\method{isochron}{ThU}(x, type = 2, xlim = NA, ylim = NA,
  alpha = 0.05, sigdig = 2, show.numbers = FALSE, levels = NA,
  clabel = "", ellipse.col = c("#00FF0080", "#FF000080"),
  ci.col = "gray80", line.col = "black", lwd = 1, plot = TRUE,
  exterr = TRUE, model = 1, ...)

\method{isochron}{UThHe}(x, xlim = NA, ylim = NA, alpha = 0.05,
  sigdig = 2, show.numbers = FALSE, ci.col = "gray80",
  line.col = "black", lwd = 1, plot = TRUE, model = 1, ...)
}
\arguments{
\item{x}{EITHER a matrix with the following five columns:

\describe{

\item{X}{the x-variable}

\item{sX}{the standard error of \code{X}}

\item{Y}{the y-variable}

\item{sY}{the standard error of \code{Y}}

\item{rXY}{the correlation coefficient of \code{X} and \code{Y}}

}

OR

an object of class \code{ArAr}, \code{KCa}, \code{PbPb},
\code{ReOs}, \code{RbSr}, \code{SmNd}, \code{LuHf}, \code{UThHe} or
\code{ThU}.}

\item{...}{optional arguments to be passed on to the generic plot
function if \code{model=2}}

\item{xlim}{2-element vector with the x-axis limits}

\item{ylim}{2-element vector with the y-axis limits}

\item{alpha}{confidence cutoff for the error ellipses and
confidence intervals}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output}

\item{show.numbers}{logical flag (\code{TRUE} to show grain numbers)}

\item{levels}{a vector with additional values to be displayed as
different background colours within the error ellipses.}

\item{clabel}{label for the colour scale}

\item{ellipse.col}{a vector of two background colours for the error
ellipses. If \code{levels=NA}, then only the first colour will
be used. If \code{levels} is a vector of numbers, then
\code{ellipse.col} is used to construct a colour ramp.}

\item{ci.col}{the fill colour for the confidence interval of the
intercept and slope.}

\item{line.col}{colour of the isochron line}

\item{lwd}{line width}

\item{plot}{if \code{FALSE}, suppresses the graphical output}

\item{title}{add a title to the plot?}

\item{model}{construct the isochron using either:

\enumerate{

\item{Error-weighted least squares regression}

\item{Ordinary least squares regression}

\item{Error-weighted least squares with overdispersion term}

}}

\item{xlab}{text label for the horizontal plot axis}

\item{ylab}{text label for the vertical plot axis}

\item{inverse}{if \code{FALSE} and \code{x} has class \code{ArAr}, plots
    \eqn{^{40}}Ar/\eqn{^{36}}Ar vs. \eqn{^{39}}Ar/\eqn{^{36}}Ar.

if \code{FALSE} and \code{x} has class \code{PbPb}, plots
\eqn{^{207}}Pb/\eqn{^{204}}Pb vs. \eqn{^{206}}Pb/\eqn{^{204}}Pb.

if \code{TRUE} and \code{x} has class \code{ArAr}, plots
    \eqn{^{36}}Ar/\eqn{^{40}}Ar vs. \eqn{^{39}}Ar/\eqn{^{40}}Ar.

if \code{TRUE} and \code{x} has class \code{PbPb}, plots
\eqn{^{207}}Pb/\eqn{^{206}}Pb vs. \eqn{^{204}}Pb/\eqn{^{206}}Pb.}

\item{exterr}{propagate external sources of uncertainty
(J, decay constant)?}

\item{growth}{add Stacey-Kramers Pb-evolution curve to the plot?}

\item{type}{following the classification of
Ludwig and Titterington (1994), one of either:

\enumerate{

\item `Rosholt type-II' isochron, setting out
\eqn{^{230}}Th/\eqn{^{232}}Th vs. \eqn{^{238}}U/\eqn{^{232}}Th

\item `Osmond type-II' isochron, setting out \eqn{^{230}}Th/\eqn{^{238}}U
vs. \eqn{^{232}}Th/\eqn{^{238}}U

\item `Rosholt type-II' isochron, setting out \eqn{^{234}}U/\eqn{^{232}}Th
vs. \eqn{^{238}}U/\eqn{^{232}}Th

\item `Osmond type-II' isochron, setting out \eqn{^{234}}U/\eqn{^{238}}U
vs. \eqn{^{232}}Th/\eqn{^{238}}U

}}
}
\value{
If \code{x} has class \code{PbPb}, \code{ArAr}, \code{KCa},
    \code{RbSr}, \code{SmNd}, \code{ReOs} or \code{LuHf}, or
    \code{UThHe}, returns a list with the following items:

\describe{

\item{a}{the intercept of the straight line fit and its standard
error.}

\item{b}{the slope of the fit and its standard error.}

\item{cov.ab}{the covariance of the slope and intercept}

\item{df}{the degrees of freedom of the linear fit (\eqn{df=n-2})}

\item{y0}{a four-element list containing:

\code{y}: the atmospheric \eqn{^{40}}Ar/\eqn{^{36}}Ar or initial
\eqn{^{40}}Ca/\eqn{^{44}}Ca, \eqn{^{207}}Pb/\eqn{^{204}}Pb,
\eqn{^{187}}Os/\eqn{^{188}}Os, \eqn{^{87}}Sr/\eqn{^{87}}Rb,
\eqn{^{143}}Nd/\eqn{^{144}}Nd or \eqn{^{176}}Hf/\eqn{^{177}}Hf
ratio.

\code{s[y]}: the propagated uncertainty of \code{y}

\code{ci[y]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{y}.

\code{disp[y]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{y} enhanced by \eqn{\sqrt{mswd}} (only
applicable if \code{ model=1}).  }

\item{age}{a four-element list containing:

\code{t}: the \eqn{^{207}}Pb/\eqn{^{206}}Pb,
\eqn{^{40}}Ar/\eqn{^{39}}Ar, \eqn{^{40}}K/\eqn{^{40}}Ca,
\eqn{^{187}}Os/\eqn{^{187}}Re, \eqn{^{87}}Sr/\eqn{^{87}}Rb,
\eqn{^{143}}Nd/\eqn{^{144}}Nd or \eqn{^{176}}Hf/\eqn{^{177}}Hf age.

\code{s[t]}: the propagated uncertainty of \code{t}

\code{ci[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{t}.

\code{disp[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{t} enhanced by \eqn{\sqrt{mswd}} (only
applicable if \code{ model=1}).  }

\item{mswd}{the mean square of the residuals (a.k.a `reduced
    Chi-square') statistic (omitted if \code{model=2}).}

\item{p.value}{the p-value of a Chi-square test for linearity
(omitted if \code{model=2})}

\item{w}{the overdispersion term, i.e. a three-element vector with
the standard deviation of the (assumedly) Normally distributed
geological scatter that underlies the measurements, and the lower
and upper half-widths of its \eqn{100(1-\alpha)\%} confidence
interval (only returned if \code{model=3}).}

}

OR, if \code{x} has class \code{ThU}:

\describe{

\item{par}{if \code{x$type=1} or \code{x$type=3}: the best fitting
\eqn{^{230}}Th/\eqn{^{232}}Th intercept,
\eqn{^{230}}Th/\eqn{^{238}}U slope, \eqn{^{234}}U/\eqn{^{232}}Th
intercept and \eqn{^{234}}U/\eqn{^{238}}U slope, OR, if
\code{x$type=2} or \code{x$type=4}: the best fitting
\eqn{^{234}}U/\eqn{^{238}}U intercept,
\eqn{^{230}}Th/\eqn{^{232}}Th slope, \eqn{^{234}}U/\eqn{^{238}}U
intercept and \eqn{^{234}}U/\eqn{^{232}}Th slope.  }

\item{cov}{the covariance matrix of \code{par}.}

\item{df}{the degrees of freedom for the linear fit, i.e. \eqn{(3n-3)} if
\code{x$format=1} or \code{x$format=2}, and \eqn{(2n-2)} if
\code{x$format=3} or \code{x$format=4}}

\item{a}{if \code{type=1}: the \eqn{^{230}}Th/\eqn{^{232}}Th
intercept; if \code{type=2}: the \eqn{^{230}}Th/\eqn{^{238}}U
intercept; if \code{type=3}: the \eqn{^{234}}Th/\eqn{^{232}}Th
intercept; if \code{type=4}: the \eqn{^{234}}Th/\eqn{^{238}}U
intercept and its propagated uncertainty.}

\item{b}{if \code{type=1}: the \eqn{^{230}}Th/\eqn{^{238}}U slope;
if \code{type=2}: the \eqn{^{230}}Th/\eqn{^{232}}Th slope; if
\code{type=3}: the \eqn{^{234}}U/\eqn{^{238}}U slope; if
\code{type=4}: the \eqn{^{234}}U/\eqn{^{232}}Th slope and its
propagated uncertainty.}

\item{cov.ab}{the covariance between \code{a} and \code{b}.}

\item{mswd}{the mean square of the residuals (a.k.a `reduced
    Chi-square') statistic.}

\item{p.value}{the p-value of a Chi-square test for linearity.}

\item{tfact}{the \eqn{100(1-\alpha/2)\%} percentile of a
t-distribution with \code{df} degrees of freedom.}

\item{y0}{a four-element vector containing:

\code{y}: the initial \eqn{^{234}}U/\eqn{^{238}}U-ratio

\code{s[y]}: the propagated uncertainty of \code{y}

\code{ci[y]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{y}.

\code{disp[y]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{y} enhanced by \eqn{\sqrt{mswd}}.}

\item{age}{a three (or four) element vector containing:

\code{t}: the initial \eqn{^{234}}U/\eqn{^{238}}U-ratio

\code{s[t]}: the propagated uncertainty of \code{t}

\code{ci[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{t}

\code{disp[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{t} enhanced by \eqn{\sqrt{mswd}} (only reported
if \code{model=1}).}

\item{w}{the overdispersion term, i.e. a three-element vector with
the standard deviation of the (assumedly) Normally distributed
geological scatter that underlies the measurements, and the lower
and upper half-width of its \eqn{100(1-\alpha)\%} confidence
interval (only returned if \code{model=3}).}

\item{d}{a matrix with the following columns: the X-variable for
the isochron plot, the analytical uncertainty of X, the Y-variable
for the isochron plot, the analytical uncertainty of Y, and the
correlation coefficient between X and Y.}

\item{xlab}{the x-label of the isochron plot}

\item{ylab}{the y-label of the isochron plot}

}
}
\description{
Plots cogenetic Ar-Ar, K-Ca, Pb-Pb, Rb-Sr, Sm-Nd, Re-Os, Lu-Hf,
U-Th-He or Th-U data as X-Y scatterplots, fits an isochron curve
through them using the \code{york} function, and computes the
corresponding isochron age, including decay constant uncertainties.
}
\details{
Given several aliquots from a single sample, isochrons allow the
non-radiogenic component of the daughter nuclide to be quantified
and separated from the radiogenic component. In its simplest form,
an isochron is obtained by setting out the amount of radiogenic
daughter against the amount of radioactive parent, both normalised
to a non-radiogenic isotope of the daughter element, and fitting a
straight line through these points by least squares regression
(Nicolaysen, 1961). The slope and intercept then yield the
radiogenic daughter-parent ratio and the non-radiogenic daughter
composition, respectively. There are several ways to fit an
isochron.  The easiest of these is ordinary least squares
regression, which weighs all data points equally. In the presence
of quantifiable analytical uncertainty, it is equally
straightforward to use the inverse of the y-errors as weights.  It
is significantly more difficult to take into account uncertainties
in both the x- and the y-variable (York, 1966). \code{IsoplotR}
does so for its U-Th-He isochron calculations. The York (1966)
method assumes that the analytical uncertainties of the x- and
y-variables are independent from each other. This assumption is
rarely met in geochronology.  York (1968) addresses this issue with
a bivariate error weighted linear least squares algorithm that
accounts for covariant errors in both variables. This algorithm was
further improved by York et al. (2004) to ensure consistency with
the maximum likelihood approach of Titterington and Halliday
(1979).

\code{IsoplotR} uses the York et al. (2004) algorithm for its
Ar-Ar, K-Ca, Pb-Pb, Rb-Sr, Sm-Nd, Re-Os and Lu-Hf isochrons. The
maximum likelihood algorithm of Titterington and Halliday (1979)
was generalised from two to three dimensions by Ludwig and
Titterington (1994) for U-series disequilibrium dating.  Also this
algorithm is implemented in \code{IsoplotR}.  The extent to which
the observed scatter in the data can be explained by the analytical
uncertainties can be assessed using the Mean Square of the Weighted
Deviates (MSWD, McIntyre et al., 1966), which is defined as:

\eqn{MSWD = ([X - \hat{X}] \Sigma_{X}^{-1} [X - \hat{X}]^T)/df}

where \eqn{X} are the data, \eqn{\hat{X}} are the fitted values,
and \eqn{\Sigma_X} is the covariance matrix of \eqn{X}, and \eqn{df
= k(n-1)} are the degrees of freedom, where \eqn{k} is the
dimensionality of the linear fit. MSWD values that are far smaller
or greater than 1 indicate under- or overdispersed measurements,
respectively. Underdispersion can be attributed to overestimated
analytical uncertainties. \code{IsoplotR} provides three
alternative strategies to deal with overdispersed data:

\enumerate{

\item Attribute the overdispersion to an underestimation of the
analytical uncertainties. In this case, the excess scatter can be
accounted for by inflating those uncertainties by a \emph{factor}
\eqn{\sqrt{MSWD}}.

\item Ignore the analytical uncertainties and perform an ordinary
least squares regression.

\item Attribute the overdispersion to the presence of `geological
scatter'.  In this case, the excess scatter can be accounted for by
adding an overdispersion \emph{term} that lowers the MSWD to unity.

}
}
\examples{
data(examples)
isochron(examples$ArAr)

fit <- isochron(examples$PbPb,inverse=FALSE,plot=FALSE)

dev.new()
isochron(examples$ThU,type=4)
}
\references{
Ludwig, K.R. and Titterington, D.M., 1994. Calculation of
\eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
Cosmochimica Acta, 58(22), pp.5031-5042.

Nicolaysen, L.O., 1961. Graphic interpretation of discordant age
measurements on metamorphic rocks. Annals of the New York Academy
of Sciences, 91(1), pp.198-206.

Titterington, D.M. and Halliday, A.N., 1979. On the fitting of
parallel isochrons and the method of maximum likelihood. Chemical
Geology, 26(3), pp.183-195.

York, D., 1966. Least-squares fitting of a straight line. Canadian
Journal of Physics, 44(5), pp.1079-1086.

York, D., 1968. Least squares fitting of a straight line with
correlated errors. Earth and Planetary Science Letters, 5,
pp.320-324.

York, D., Evensen, N.M., Martinez, M.L. and De Basebe Delgado, J., 2004.
Unified equations for the slope, intercept, and standard
errors of the best straight line. American Journal of Physics,
72(3), pp.367-375.
}
\seealso{
\code{\link{york}},
\code{\link{titterington}},
\code{\link{ludwig}}
}
