% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\name{lambda}
\alias{lambda}
\title{Decay constants}
\usage{
lambda(nuclide, x = NULL, e = NULL)
}
\arguments{
\item{nuclide}{the nuclide name}

\item{x}{new value for the decay constant}

\item{e}{new value for the decay constant uncertainty}
}
\value{
if \code{x==e==NULL}, returns a two-item vector containing
    the decay constant [in Ma-1] and its standard error,
    respectively.
}
\description{
Gets or sets the decay constants of radioactive isotopes
}
\examples{
print(lambda('U238'))
# use the decay constant of Kovarik and Adams (1932)
lambda('U238',0.0001537,0.0000068)
print(lambda('U238'))
}
\references{
U: Jaffey, A. H., et al. "Precision measurement of half-lives and
specific activities of U 235 and U 238." Physical Review C 4.5 (1971): 1889.

Th: Le Roux, L. J., and L. E. Glendenin. "Half-life of 232Th."
Proceedings of the National Meeting on Nuclear Energy, Pretoria, South Africa. 1963.

Ar: Renne, Paul R., et al. "Joint determination of 40K decay
constants and 40Ar*/40K for the Fish Canyon sanidine standard,
and improved accuracy for 40Ar/39Ar geochronology."
Geochimica et Cosmochimica Acta 74.18 (2010): 5349-5367.
}

