% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cad.R
\name{cad}
\alias{cad}
\alias{cad.default}
\alias{cad.detritals}
\alias{cad.UPb}
\alias{cad.PbPb}
\alias{cad.ArAr}
\alias{cad.ThU}
\alias{cad.ReOs}
\alias{cad.SmNd}
\alias{cad.RbSr}
\alias{cad.LuHf}
\alias{cad.UThHe}
\alias{cad.fissiontracks}
\title{Plot continuous data as cumulative age distributions}
\usage{
cad(x, ...)

\method{cad}{default}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  colmap = "heat.colors", col = "black", ...)

\method{cad}{detritals}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  colmap = "heat.colors", ...)

\method{cad}{UPb}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  col = "black", type = 4, cutoff.76 = 1100, cutoff.disc = c(-15, 5),
  ...)

\method{cad}{PbPb}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  col = "black", i2i = FALSE, ...)

\method{cad}{ArAr}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  col = "black", i2i = FALSE, ...)

\method{cad}{ThU}(x, pch = NA, verticals = TRUE, xlab = "age [ka]",
  col = "black", i2i = FALSE, ...)

\method{cad}{ReOs}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  col = "black", i2i = TRUE, ...)

\method{cad}{SmNd}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  col = "black", i2i = TRUE, ...)

\method{cad}{RbSr}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  col = "black", i2i = TRUE, ...)

\method{cad}{LuHf}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  col = "black", i2i = TRUE, ...)

\method{cad}{UThHe}(x, pch = NA, verticals = TRUE, xlab = "age [Ma]",
  col = "black", ...)

\method{cad}{fissiontracks}(x, pch = NA, verticals = TRUE,
  xlab = "age [Ma]", col = "black", ...)
}
\arguments{
\item{x}{a numerical vector OR an object of class \code{UPb},
\code{PbPb}, \code{ArAr}, \code{UThHe}, \code{fissiontracks},
\code{ReOs}, \code{RbSr}, \code{SmNd}, \code{LuHf}, \code{ThU}
or \code{detritals}}

\item{...}{optional arguments to the generic \code{plot} function}

\item{pch}{plot character to mark the beginning of each CAD step}

\item{verticals}{logical flag indicating if the horizontal lines of
the CAD should be connected by vertical lines}

\item{xlab}{x-axis label}

\item{colmap}{an optional string with the name of one of \code{R}'s
built-in colour palettes (e.g., \code{heat.colors},
\code{terrain.colors}, \code{topo.colors}, \code{cm.colors}),
which are to be used for plotting data of class
\code{detritals}.}

\item{col}{colour to give to single sample datasets (not applicable
if \code{x} has class \code{detritals})}

\item{type}{scalar indicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (\code{type}=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (\code{type}=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (\code{type}=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(\code{type}=4), or the (Wetherill) concordia age
(\code{type}=5)}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U-age and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{two element vector with the maximum and minimum
percentage discordance allowed between the
\eqn{^{207}}Pb/\eqn{^{235}}U and \eqn{^{206}}Pb/\eqn{^{238}}U
age (if \eqn{^{206}}Pb/\eqn{^{238}}U < cutoff.76) or between
the \eqn{^{206}}Pb/\eqn{^{238}}U and
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (if
\eqn{^{206}}Pb/\eqn{^{238}}U > cutoff.76).  Set
\code{cutoff.disc=NA} if you do not want to use this filter.}

\item{i2i}{`isochron to intercept': calculates the initial
(aka `inherited', `excess', or `common') \eqn{^{40}}Ar/\eqn{^{36}}Ar,
\eqn{^{207}}Pb/\eqn{^{204}}Pb, \eqn{^{87}}Sr/\eqn{^{86}}Sr,
\eqn{^{143}}Nd/\eqn{^{144}}Nd, \eqn{^{187}}Os/\eqn{^{188}}Os or
\eqn{^{176}}Hf/\eqn{^{177}}Hf ratio from an isochron
fit. Setting \code{i2i} to \code{FALSE} uses the default values
stored in \code{settings('iratio',...)}  or zero (for the Pb-Pb
method). When applied to data of class \code{ThU}, setting
\code{i2i} to \code{TRUE} applies a detrital Th-correction.}
}
\description{
Plot a dataset as a Cumulative Age Distribution (CAD), also known
as a `empirical cumulative distribution function'.
}
\examples{
data(examples)
cad(examples$DZ,verticals=FALSE,pch=20)
}
\references{
Vermeesch, P., 2007. Quantitative geomorphology of the
    White Mountains (California) using detrital apatite fission
    track thermochronology. Journal of Geophysical Research: Earth
    Surface, 112(F3).
}
