% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irescale.R
\name{rescaleI}
\alias{rescaleI}
\title{Performs the rescale for all the variables in an input file.}
\usage{
rescaleI(data, samples = 10000, scalingUpTo = "Quantile")
}
\arguments{
\item{data}{the data frame obtained from \code{loadFile}.}

\item{samples}{number of permutations for the resampling method.}

\item{scalingUpTo}{the rescaling could be done up to the 0.01\% and 99.99\% quantile or max and min values. The two possible options are: "MaxMin", or "Quantile". The default value for this parameter is "Quantile"}
}
\value{
An object with I, rescaleI and statistic summary for the inputs without scaling, the same statistics after scaling them, the p-value and the convexhull information
}
\description{
\code{rescaleI} It executes the whole analysis for all the measurements in the field.
\itemize{
\item It plots the histogram with the theorical distribution.
\item It plots the convexHull for each variable.
\item It calcualtes the area and centroid of the convex hull for each variable.
\item It calculates the I and rescale it for every variable.
\item It returns an object with the computations.
}
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
data <- loadFile(fileInput)
scaledI<-rescaleI(data,1000)
}
