% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irescale.R
\name{calculatePvalue}
\alias{calculatePvalue}
\title{p-value calculation.}
\usage{
calculatePvalue(sample, value, mean)
}
\arguments{
\item{sample}{the vector that will be used as reference.}

\item{value}{the value of interest.}

\item{mean}{the mean of interest.}
}
\description{
\code{calculatePvalue} calculates a p-value for the null hypothesis.
}
\examples{
fileInput<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(fileInput)
distM<-calculateEuclideanDistance(input$data)
I<-calculateMoranI(distM = distM,varOfInterest = input$varOfInterest)
vI<-resamplingI(1000,distM, input$varOfInterest) # This is the permutation
statsVI<-summaryVector(vI)
corrections<-iCorrection(I,vI)
pv<-calculatePvalue(corrections$scaledData,corrections$newI,corrections$summaryScaledD$mean)
}
