% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multi_D_mod.R
\name{Node_cost}
\alias{Node_cost}
\title{Information Gain}
\usage{
Node_cost(y, Inv_Cov_Y, Command)
}
\arguments{
\item{y}{Output Features for the samples of the node}

\item{Inv_Cov_Y}{Inverse of Covariance matrix of Output Response matrix for MRF(Input [0 0;0 0] for RF)}

\item{Command}{1 for univariate Regression Tree (corresponding to RF) and 2 for Multivariate Regression Tree (corresponding to MRF)}
}
\value{
cost or entropy of samples in a node of a tree
}
\description{
Compute the cost function of a tree node
}
\details{
In multivariate trees (MRF) node cost is measured as the sum of squares of the Mahalanobis distance to capture the correlations in 
the data whereas in univariate trees node cost is measured as the sum of Euclidean distance square. Mahalanobis Distance captures 
the distance of the sample point from the mean of the node along the principal component axes.
}
\examples{
library(IntegratedMRF)
y=matrix(runif(10*2),10,2)
Inv_Cov_Y=solve(cov(y))
Command=2
#Command=2 for MRF and 1 for RF
#This function calculates information gain of a node
Cost=Node_cost(y,Inv_Cov_Y,Command)
}
\references{
Segal, Mark, and Yuanyuan Xiao. "Multivariate random forests." 
Wiley Interdisciplinary Reviews: Data Mining and Knowledge Discovery 1.1 (2011): 80-87.
}

