% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{ComparePlot}
\alias{ComparePlot}
\title{Comparison of clustering results over multiple results}
\usage{
ComparePlot(List, nrclusters = NULL, cols = NULL, fusionsLog = FALSE,
  weightclust = FALSE, names = NULL, margins = c(8.1, 3.1, 3.1, 4.1),
  circle = FALSE, canvaslims = c(-1, 1, -1, 1), Highlight = NULL,
  plottype = "new", location = NULL)
}
\arguments{
\item{List}{A list of the outputs from the methods to be compared. The first
element of the list will be used as the reference in
\code{ReorderToReference}.}

\item{nrclusters}{The number of clusters to cut the dendrogram in. Default is NULL.}

\item{cols}{A character vector with the colours to be used. Default is NULL.}

\item{fusionsLog}{Logical. To be handed to \code{ReorderToReference}: indicator for the fusion of clusters. Default is TRUE}

\item{weightclust}{Logical. To be handed to \code{ReorderToReference}: to be used for the outputs of CEC,
WeightedClust or WeightedSimClust. If TRUE, only the result of the Clust element is considered. Default is TRUE.}

\item{names}{Optional. Names of the methods to be used as labels for the
columns. Default is NULL.}

\item{margins}{Optional. Margins to be used for the plot. Default is c(8.1,3.1,3.1,4.1).}

\item{circle}{Logical. Whether the figure should be circular (TRUE) or a rectangle (FALSE). Default is FALSE.}

\item{canvaslims}{The limits for the circular dendrogam. Default is c(-1.0,1.0,-1.0,1.0).}

\item{Highlight}{Optional. A list of character vectors of objects to be highlighted. The names of the elements in the list are the names to appear on the figure. The median similarities of the objects in each list elemented is computed. Default is NULL.}

\item{plottype}{Should be one of "pdf","new" or "sweave". If "pdf", a
location should be provided in "location" and the figure is saved there. If
"new" a new graphic device is opened and if "sweave", the figure is made
compatible to appear in a sweave or knitr document, i.e. no new device is
opened and the plot appears in the current device or document. Default is "new".}

\item{location}{Optional. If plottype is "pdf", a location should be provided in
"location" and the figure is saved there. Default is NULL.}
}
\value{
A plot which translates the matrix output of the function
\code{ReorderToReference} in which the columns represent the objects in the
ordering the referenced method and the rows the outputs of the given
methods. Each cluster is given a distinct color. This way it can be easily
observed which objects will cluster together. The labels on the right side
of the plot are the similarity measures computed by
\code{SimilarityMeasure}.
}
\description{
A visual comparison of all methods is handy to see which objects will
always cluster together independent of the applied methods. To this aid the
function \code{ComparePlot} has been written. The function relies on methods
of the \code{circlize} package.
}
\details{
This function makes use of the functions \code{ReorderToReference} and
\code{Colorsnames}.  Given a list with the outputs of several methods, the
first step is to call upon \code{ ReorderToReference} and to produce a
matrix of which the columns are ordered according to the ordering of the
objects of the first method in the list. Each cell represent the number of
the cluster the object belongs to for a specific method indicated by the
rows. The clusters are arranged in such a way that these correspond to that
one cluster of the referenced method that they have the most in common with.
The function \code{color2D.matplot} produces a plot of this matrix but needs
a vector indicating the names of the colors to be used. This is where
\code{ColorsNames} comes in. A vector of the color names of the output of
the \code{ReorderToReference} is created and handed to
\code{color2D.matplot}. It is optional to adjust the margins of the plot and
to give a vector with the names of the methods which will be used as labels
for the rows in the plot. The labels for the columns are the names of the
object in the order of clustering of the referenced method. Further, the
similarity measures of the methods compared to the reference will be
computed and shown on the right side of the plot.
}
\examples{
\dontrun{
data(fingerprintMat)
data(targetMat)
data(Colors1)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(MCF7_F,MCF7_T)
N=c("FP","TP")

#rectangular
ComparePlot(List=L,nrclusters=7,cols=Colors1,fusionsLog=TRUE,weightclust=TRUE,
names=N,margins=c(9.1,4.1,4.1,4.1),plottype="new",location=NULL)

#circle
Comps_I=c("fluphenazine","trifluoperazine","prochlorperazine","chlorpromazine")  
Comps_II=c("butein","genistein","resveratrol")

ComparePlot(List=L,nrclusters=7,cols=c(Colors1), fusionsLog=TRUE,weightclust=FALSE,
names =N, margins = c(8.1, 3.1,3.1, 4.1),circle=TRUE,canvaslims=c(-1.1,1.1,-1.1,1.1),
Highlight=list("Comps I"=Comps_I,"Comps II"=Comps_II,"Cancer Treatments"=c("estradiol",
"fulvestrant")),plottype = "new")
}
}
