% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{somersD}
\alias{somersD}
\title{somersD}
\usage{
somersD(actuals, predictedScores)
}
\arguments{
\item{actuals}{The actual binary flags for the response variable. It can take a numeric vector containing values of either 1 or 0, where 1 represents the 'Good' or 'Events' while 0 represents 'Bad' or 'Non-Events'.}

\item{predictedScores}{The prediction probability scores for each observation. If your classification model gives the 1/0 predcitions, convert it to a numeric vector of 1's and 0's.}
}
\value{
The Somers D statistic, which tells how many more concordant than discordant pairs exist divided by total number of pairs.
}
\description{
Calculate the Somers D statistic for a given logit model
}
\details{
For a given binary response actuals and predicted probability scores, Somer's D is calculated as the number of concordant pairs less number of discordant pairs divided by total number of pairs.
}
\examples{
data('ActualsAndScores')
somersD(actuals=ActualsAndScores$Actuals, predictedScores=ActualsAndScores$PredictedScores)
}
\author{
Selva Prabhakaran \email{selva86@gmail.com}
}

