/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.ref;

import hep.aida.tdouble.DoubleIAxis;

public class DoubleFixedAxis
implements DoubleIAxis {
    private static final long serialVersionUID = 1L;
    private int bins;
    private double min;
    private double binWidth;
    private int xunder;
    private int xover;

    public DoubleFixedAxis(int n, double d, double d2) {
        if (n < 1) {
            throw new IllegalArgumentException("bins=" + n);
        }
        if (d2 <= d) {
            throw new IllegalArgumentException("max <= min");
        }
        this.bins = n;
        this.min = d;
        this.binWidth = (d2 - d) / (double)n;
    }

    public double binCentre(int n) {
        return this.min + this.binWidth * (double)n + this.binWidth / 2.0;
    }

    public double binLowerEdge(int n) {
        if (n == -2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n == -1) {
            return this.upperEdge();
        }
        return this.min + this.binWidth * (double)n;
    }

    public int bins() {
        return this.bins;
    }

    public double binUpperEdge(int n) {
        if (n == -2) {
            return this.min;
        }
        if (n == -1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.min + this.binWidth * (double)(n + 1);
    }

    public double binWidth(int n) {
        return this.binWidth;
    }

    public int coordToIndex(double d) {
        if (d < this.min) {
            return -2;
        }
        int n = (int)Math.floor((d - this.min) / this.binWidth);
        if (n >= this.bins) {
            return -1;
        }
        return n;
    }

    public double lowerEdge() {
        return this.min;
    }

    public double upperEdge() {
        return this.min + this.binWidth * (double)this.bins;
    }

    int xgetBin(double d) {
        if (d < this.min) {
            return this.xunder;
        }
        int n = (int)Math.floor((d - this.min) / this.binWidth);
        if (n > this.bins) {
            return this.xover;
        }
        return n + 1;
    }

    int xmap(int n) {
        if (n >= this.bins) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return this.xunder;
        }
        if (n == -1) {
            return this.xover;
        }
        throw new IllegalArgumentException("bin=" + n);
    }
}

