% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_mat_function.R
\name{adjust_mat}
\alias{adjust_mat}
\title{Adjust Matrix}
\usage{
adjust_mat(
  source,
  target,
  remove = TRUE,
  add = TRUE,
  value = NA,
  returnlabels = FALSE
)
}
\arguments{
\item{source}{A matrix which should be adjusted (one-mode & directed).}

\item{target}{A matrix (one-mode & directed) to which the source object is compared with regard to its labels.}

\item{remove}{Should rows and columns that are not present in the target object be removed?}

\item{add}{Should rows and columns that are present in the target object but not in the source object be added to the source object?}

\item{value}{The value to be inserted if a new row or column is added. By default, new cells are filled with NA values, but other sensible values may include -Inf or 0.}

\item{returnlabels}{Return a list of added and removed row and column labels rather than the actual matrix, vector, or network object?}
}
\value{
Matrix
}
\description{
adjust the dimensions of a source object to the dimensions of a target object
}
