% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNhistdegdist_function.R
\name{ITNhistdegdist}
\alias{ITNhistdegdist}
\title{ITN Histogram Degree Distribution}
\usage{
ITNhistdegdist(gs)
}
\arguments{
\item{gs}{International Trade Network - igraph object}
}
\value{
Panel of ITN histogram degree distribtuion plots
}
\description{
This function plots the ITN histogram degree distribtuion
}
\examples{
require(igraph)
##Create random International Trade Network (igraph object)
ITN<-erdos.renyi.game(75,0.05,directed = TRUE)
##Add edge weights
E(ITN)$weight<-runif(ecount(ITN), 0, 1)

##Plot degree distribution histogram
hist_deg_dist<-ITNhistdegdist(ITN)
}
