% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{model.transform}
\alias{model.transform}
\title{Model transformations}
\usage{
model.transform(z, model, src, target, byrow = F)
}
\arguments{
\item{z}{The parameter matrix or named list.}

\item{model}{The model to transform.}

\item{src}{The original parameter to transform.}

\item{target}{The target parameter of the transform.}

\item{byrow}{Read matrix by row.}
}
\value{
z The parameters with the transform.
}
\description{
Implements parameter transforms from one parameter to others dependent on the model
Currently only 3PL, supported with passings between b <-> d and c <-> cp'
}
\examples{
## create the dataset
# data <- simulateTest(model = "3PL", items = 20, individuals = 200)
## extract the parameters and transform them from one list to matrix.
# zita <-data$itempars
# zita <- list(zita$a, zita$b, zita$c)
# zita <- parameter.matrix(zita)
## transform the model parameters
# model.transform(zita, model = "3PL", src = "b", target = "d")
# model.transform(zita, model = "3PL", src = "c", target = "cp")
}

