% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.RT.PMF}
\alias{Plot.RT.PMF}
\alias{Plot.RT.PMF.DataSetList}
\title{Plot probablity mass function of the runtimes of a DataSetList at a certain target function value}
\usage{
Plot.RT.PMF(dsList, ftarget, show.sample = F, scale.ylog = F,
  backend = NULL)

\method{Plot.RT.PMF}{DataSetList}(dsList, ftarget, show.sample = F,
  scale.ylog = F, backend = NULL)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{ftarget}{The target function value.}

\item{show.sample}{Whether or not to show the individual runtime samples}

\item{scale.ylog}{Whether or not to scale the y-axis logaritmically}

\item{backend}{Which plotting library to use. Can be 'plotly' or 'ggplot2'}
}
\value{
A plot of the probablity mass function of the runtimes at a the
        target function value of the DataSetList
}
\description{
Plot probablity mass function of the runtimes of a DataSetList at a certain target function value
}
\examples{
Plot.RT.PMF(subset(dsl, funcId == 1), 14)
}
