% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.FV.Single_Func}
\alias{Plot.FV.Single_Func}
\alias{Plot.FV.Single_Func.DataSetList}
\title{Plot lineplot of the expected function values of a DataSetList}
\usage{
Plot.FV.Single_Func(dsList, RTstart = NULL, RTstop = NULL,
  show.CI = F, show.mean = T, show.median = F, backend = NULL,
  scale.xlog = F, scale.ylog = F, scale.reverse = F)

\method{Plot.FV.Single_Func}{DataSetList}(dsList, RTstart = NULL,
  RTstop = NULL, show.CI = F, show.mean = T, show.median = F,
  backend = NULL, scale.xlog = F, scale.ylog = F,
  scale.reverse = F)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{RTstart}{The starting runtime value.}

\item{RTstop}{The final runtime value.}

\item{show.CI}{Whether or not to show the standard deviations}

\item{show.mean}{Whether or not to show the mean runtimes}

\item{show.median}{Whether or not to show the median runtimes}

\item{backend}{Which plotting library to use. Can be 'plotly' or 'ggplot2'}

\item{scale.xlog}{Whether or not to scale the x-axis logaritmically}

\item{scale.ylog}{Whether or not to scale the y-axis logaritmically}

\item{scale.reverse}{Wheter or not to reverse the x-axis (when using minimization)}
}
\value{
A plot of ERT-values of the DataSetList
}
\description{
Plot lineplot of the expected function values of a DataSetList
}
\examples{
Plot.FV.Single_Func(subset(dsl, funcId == 1))
}
