% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.FV.Histogram}
\alias{Plot.FV.Histogram}
\alias{Plot.FV.Histogram.DataSetList}
\title{Plot histograms of the function values of a DataSetList at a certain target runtime}
\usage{
Plot.FV.Histogram(dsList, runtime, plot_mode = "overlay",
  use.equal.bins = F)

\method{Plot.FV.Histogram}{DataSetList}(dsList, runtime,
  plot_mode = "overlay", use.equal.bins = F)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{runtime}{The target runtime}

\item{plot_mode}{How to plot the different hisograms for each algorithm. Can be either
'overlay' to show all algorithms on one plot, or 'subplot' to have one plot per algorithm.}

\item{use.equal.bins}{Whether to determine one bin size for all plots or have individual bin sizes for each algorithm}
}
\value{
A plot of the histograms of the function values at a the
        target runtime of the DataSetList
}
\description{
Plot histograms of the function values of a DataSetList at a certain target runtime
}
\examples{
Plot.FV.Histogram(subset(dsl, funcId == 1), 100)
}
