% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar2cor.R
\name{ar2cor}
\alias{ar2cor}
\title{Illustrative code to compute the auto-correlation for an AR2 model.}
\usage{
ar2cor(a1, a2, k = 30)
}
\arguments{
\item{a1}{the first auto-regression coefficient.}

\item{a2}{the second auto-regression coefficient.}

\item{k}{maximum lag for evaluating the auto-correlation.}
}
\value{
the autocorrelation as a vector or matrix, whenever \code{a1} or \code{a2} are
scalar or vector.
}
\description{
Computes the auto-correlation.
}
\section{Details}{

Let the second order auto-regression model defined as
\verb{x_t + a_1 x_\{t-1\} + a_2 x_\{t-2\} = w_t}
where \code{w_t ~ N(0, 1)}.
}

\examples{
plot(ar2cor(-1.7, 0.963), type = "o")
}
\seealso{
\link{ar2precision}
}
