% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CV.R
\docType{data}
\name{CV.nb}
\alias{CV.nb}
\title{Adjacency matrix of municipalities in Comunidad Valenciana (Spain)}
\format{
An \code{nb} object with the adjacencies of the municipalities in
Comunidad Valenciana (Spain) to be used for the spatial models.
}
\source{
The original data set is supplied as supplementary material of the
book: "Martinez-Beneito, M A & Botella Rocamora, P. Disease mapping: from
foundations to multidimensional modeling. CRC/Chapman & Hall, 2019". This
object has been built from several of the files available at the 
supplementary material repository of the book at:
\url{https://github.com/MigueBeneito/DisMapBook/tree/master/Data}
}
\usage{
data(CV)
}
\description{
Adjacency matrix of municipalities in Comunidad Valenciana (Spain)
}
\examples{
require(sp)
require(spdep)
data(CV)
plot(CV)
plot(CV.nb, coordinates(CV), pch = ".", col = "gray", add = TRUE)

}
\references{
Martinez-Beneito, M A & Botella Rocamora, P. Disease mapping: 
from foundations to multidimensional modeling. CRC/Chapman & Hall, 2019.
}
\seealso{
CV
}
\keyword{datasets}
