% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrmse.R
\name{nrmse}
\alias{nrmse}
\title{Normalized Root Mean Square Error}
\usage{
nrmse(pred, obs, method = "sd", transformation = "none",
  trans_function = "none")
}
\arguments{
\item{pred}{A vector of predicted values.}

\item{obs}{A vector of observed values.}

\item{method}{A character string indicating the value to be used for the normalization of the RMSE.
The default is the standard deviation. Alternatively, you can choose the \code{"mean"},
\code{"maxmin"} (difference between the maximum and minimum observed values) or \code{"iq"}
(interquartile)}

\item{transformation}{The type of transformation applied to the observations
prior to the analysis. Choose one of the following: \code{"none"} (default), \code{"sqrt"},
\code{"4thrt"} (fourth root),
\code{"log"} (natural logarithm), \code{"log10"} (common, i.e. base 10, logarithm),
\code{"log2"} (binary logarithm), \code{"log1p"} (i.e. log(1+x)),
\code{"arcsine"} (if data is proportional, NOT percentage) or \code{"other"}.}

\item{trans_function}{If \code{transformation} is set to "\code{"other"}, the function
for the back-transformation needs to be defined here as character string (simply the inverse of
the original transformation), e.g. "5^x" if observations log(x, base = 5) transformed or
"exp(x) - 0.001" if observations log(x + 0.001) transformed. Default is \code{"none"}.}
}
\value{
The function returns a single NRMSE value (expressed as absolute value). In case the
number of positions with non-missing values in both pred and obs is less then 2, NA is returned
with a message.
}
\description{
\code{nrmse} is a function that allows the user to calculate the normalized root
mean square error (NRMSE) as absolute value between predicted
and observed values using different type of normalization methods.
It further allows the NRMSE calculation on the scale of the untransformed
indicator, which is advisable for a comparison across indicators.
}
\details{
The for most common normalization methods are implemented here:

- the **mean**:   NRMSE = RMSE / mean(obs)
- the **standard deviation**:  NRMSE = RMSE / sd(obs)
- the **difference between maximum and minimum**:  NRMSE = RMSE / (max(obs)-min(obs)
- the **interquartile range**; NRMSE = RMSE / (Q1-Q3), i.e. the
difference between the 25th and 75th percentile of observations

Missing values in obs and pred are removed before the computation proceeds, and
only those positions with non-missing values in both pred and obs are considered in the
computation.
}
\examples{
obs <- c(10, 14, 20)
pred <- c(9, 12, 13)
# Calculating the sd-based NRMSE for untransformed data
nrmse(pred, obs)
# Calculating the iq-based NRMSE for log(x+0.001) transformed data
nrmse(pred, obs, method = "iq", transformation = "other", trans_function = "exp(x)-0.001")
}
\seealso{
\code{\link{calc_nrmse}}
}
