% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.atr.R
\name{get.atr}
\alias{get.atr}
\alias{get.nas}
\alias{get.varlab}
\title{Retrieve tibble attributes}
\usage{
get.atr(tibble, which, NULLasNA = TRUE, exact = FALSE)

get.nas(tibble, aslist = TRUE)

get.varlab(tibble)
}
\arguments{
\item{tibble}{a tibble object.}

\item{which}{a non-empty character string specifying which attribute
    is to be accessed.}

\item{NULLasNA}{a logical value indicating if \code{NULL} attributes
should be listed as NA. Default is \code{TRUE}.}

\item{exact}{logical: should \code{which} be matched exactly?}

\item{aslist}{a logical value indicating if output should be a list.}
}
\value{
A list or a data frame.
}
\description{
Retrieves attributes from a tibble object created by haven.
}
\examples{
# tibble generated by haven
input <- system.file("extdata/reds", package = "ILSAmerge")
x <- do.call(rbind,justload(inputdir = input,population = "BCGV1"))
x

# Get an attribute
get.atr(tibble = x, which = "label")[1:3]
get.atr(tibble = x, which = "labels")[1:3]
get.atr(tibble = x, which = "format.spss")[1:3]

# Get NAs
get.nas(tibble = x,aslist = TRUE)[10:20]
get.nas(tibble = x,aslist = FALSE)[10:20,]

# Get variable labels
get.varlab(tibble = x)[10:20,]

}
\keyword{tibblemanagement}
