% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILSAdownload.R
\name{ILSAdownload}
\alias{ILSAdownload}
\title{Download ILSA data}
\usage{
ILSAdownload(
  study,
  year,
  outputdir,
  unzip = FALSE,
  maxtime = 999,
  quiet = FALSE,
  agreeLicense = FALSE
)
}
\arguments{
\item{study}{a string indicating the name of the study. For available studies
check the description of this function.}

\item{year}{a numeric value indicating the year of the study.}

\item{outputdir}{the directory where the merged data will be saved.}

\item{unzip}{a logical value indicating if files should be unzipped.
Default is \code{FALSE}.}

\item{maxtime}{a numeric value indicating the maximum time allowed for 
downloading a file. Default is \code{999}.}

\item{quiet}{a logical value indicating if status of progress should be
shown. If a study has sub-studies, e.g. 'PISA' 2009 and this is \code{TRUE},
only the main study will be downloaded.
Default is \code{FALSE}.}

\item{agreeLicense}{a logical value indicating if you agree with
the Disclaimer and License Agreement file from www.iea.nl. If \code{FALSE},
you will be prompted to agree with it or else data will not be downloaded.
Default is \code{FALSE}.}
}
\value{
Saves 'SPSS' ILSA data locally.
}
\description{
Downloads 'SPSS' data from different International Large-Scale Assessments (ILSA).
This functions supports the following ILSA: 'PISA', 'TIMSS', 'TIMSS Advanced', 'PIRLS', 
'ICCS', 'ICILS', 'CIVED', 'REDS', 'RLII', and 'SITES.' Depending on the study, 
you will need to decide which data to download, and
read and accept its terms and conditions to proceed with the download.
}
\examples{
# For example, to download 'RLII' 1991 data:

# Path were files will be saved
output <- tempdir()


# Downloading 'RLII' 1991 and unzipping files
ILSAdownload(study = "RLII", year = 1991, outputdir = output, unzip = TRUE, agreeLicense = TRUE)


}
