% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.fqcs.R
\name{QuantileDepth}
\alias{QuantileDepth}
\title{Creates a 'lab.fqcs' object to estimate functional quantiles using data depth procedures.}
\usage{
QuantileDepth(x, quantile = 0.95)
}
\arguments{
\item{x}{Object of type fdata}

\item{quantile}{Probability defined in the interval [0,1]}
}
\description{
It defines a \code{lab.fqcs} object to estimate functional quantiles using data depth procedures (Lopez-Pintado and Romo, 2009).
The required functional quantiles are obtained from data depths values of each curve. 
If quantile argument is 0.9, 0.95 and 0.05 functional quantiles are obtained.
}
\examples{
\dontrun{
library(ILS)
data(TG)
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
curves.fqcd <- lab.fqcd(TG, argvals = delta)
n <- curves.fqcd$n
m <- curves.fqcd$m
p <- curves.fqcd$p
curves.all <- TG[,,1]
for(i in 2:p) curves.all <- rbind(curves.all,TG[,,i])
curves.fdata <- fdata(mdata = curves.all,delta)
qd <- QuantileDepth(curves.fdata)
windows(20,10)
par(mfrow=c(1,2))
plot(qd, main="Quantiles of TG curves (95\%)",col=c("red","blue"),lwd=2,legend = FALSE)
legend(50,80,c("Quantile 2.5\%","Quantile 97.5\%"),
      col=c("red","blue"),lty=c(1,1),lwd=1,cex=0.7)
plot(curves.fdata,main="Quantiles of TG curves (95\%)",col="gray")
for(i in 1:2)
lines(qd[[i]],col="red",lty = 2,lwd = 2)
legend(50,80,c("Quantiles","TG Curves (105)"),
      col=c("red","gray"),lty=c(1,2),lwd=2,cex=0.7)
par(mfrow=c(1,1))
}
}
\references{
\describe{
  \item{}{Febrero-Bande, M. and Oviedo, M. (2012),
   "Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.}
  \item{}{Lopez-Pintado, S. and Romo, J. (2009), "On the concept of depth for functional data", 
  Journal of the American Statistical Association, 104, 486-503. }
}
}

