% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logMINDEX.R
\name{logMINDEX}
\alias{logMINDEX}
\title{The Multipoint Morisita Index in 1, 2 or Higher Dimensions}
\usage{
logMINDEX(X, scaleQ=1:5, mMin=2, mMax=2)
}
\arguments{
\item{X}{A \eqn{N \times E}{N x E} \code{matrix}, \code{data.frame} or \code{data.table} where \eqn{N} is the number
of data points and \eqn{E} is the number of variables (or features). The values of \code{X}
are rescaled to the \eqn{[0,1]} interval by the function.}

\item{scaleQ}{Either a single value or a vector. It contains the value(s) of \eqn{l^{(-1)}}{l^(-1)}
chosen by the user (by default: \code{scaleQ = 1:5}).}

\item{mMin}{The minimum value of \eqn{m} (by default: \code{mMin = 2}).}

\item{mMax}{The maximum value of \eqn{m} (by default: \code{mMax = 2}).}
}
\value{
A \code{data.frame} containing the \eqn{\ln}{ln} value of the m-Morisita index for each value of
\eqn{\ln (\delta)}{ln(delta)} and \eqn{m}. Notice also that the values of
\eqn{\ln (\delta)}{ln(delta)} are provided with regard to the \eqn{[0,1]} interval.
}
\description{
Computes the ln values of the multipoint Morisita index in 1, 2 or higher dimensional spaces.
}
\details{
\enumerate{
\item \eqn{\ell}{l} is the edge length of the grid cells (or quadrats). Since the data
(and consenquently the grid) are rescaled to the \eqn{[0,1]} interval, \eqn{\ell}{l} is equal
to \eqn{1} for a grid consisting of only one cell.
\item \eqn{\ell^{(-1)}}{l^(-1)} is the number of grid cells (or quadrats) along each axis of the
Euclidean space in which the data points are embedded.
\item \eqn{\ell^{(-1)}}{l^(-1)} is equal to \eqn{Q^{(1/E)}}{Q^(1/E)} where \eqn{Q} is the number
of grid cells and \eqn{E} is the number of variables (or features).
\item \eqn{\ell^{(-1)}}{l^(-1)} is directly related to \eqn{\delta}{delta} (see References).
\item \eqn{\delta}{delta} is the diagonal length of the grid cells.
}
}
\examples{
N <- 1000
sim_dat <- SwissRoll(N)

m <- 2
scaleQ <- seq(1,15,1) # It starts with a grid of 1^E cell (or quadrat).
                      # It ends with a grid of 15^E cells (or quadrats).
lnmMI <- logMINDEX(sim_dat, scaleQ, m, m)

dev.new(width=5, height=4)
plot(exp(lnmMI[,1]),exp(lnmMI[,2]),pch=19,col="black",xlab="",ylab="")
title(xlab = expression(delta), cex.lab = 1.5,line = 2.5)
title(ylab = expression(I['2,'*delta]), cex.lab = 1.5,line = 2.5)

dev.new(width=5, height=4)
plot(lnmMI[,1],lnmMI[,2],pch=19,col="black",xlab="",ylab="")
title(xlab = expression(paste("log(",delta,")")), cex.lab = 1.5,line = 2.5)
title(ylab = expression(paste("log(",I['2,'*delta],")")), cex.lab = 1.5,line = 2.5)
}
\references{
J. Golay and M. Kanevski (2015). A new estimator of intrinsic dimension
based on the multipoint Morisita index,
\href{http://www.sciencedirect.com/science/article/pii/S0031320315002320}{Pattern Recognition 48 (12):4070–4081}.
}
\author{
Jean Golay \email{Jean.Golay@unil.ch}
}
