% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.theta.permute}
\alias{get.theta.permute}
\title{get the null distribution of the \code{get.theta} function}
\usage{
get.theta.permute(
  posmat,
  fun,
  r = 1,
  r.low = rep(0, length(r)),
  permutations,
  data.frame = TRUE
)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{fun}{the function to evaluate}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
theta values for all the distances we looked at
}
\description{
Does permutations to calculate the null distribution of get theta
if there were no spatial dependence. Randomly reassigns coordinates
to each observation permutations times
}
\examples{
\donttest{

#compare normally distributed with uniform points
x<-cbind(1,runif(100,-100,100), runif(100,-100,100))
x<-rbind(x, cbind(2,rnorm(100,0,20), rnorm(100,0,20)))
colnames(x) <- c("type","x","y")

fun<-function(a,b) {
    if(a[1]!=2) return(3)
    if (b[1]==2) return(1)
    return(2)
}

r.max<-seq(10,100,10)
r.min<-seq(0,90,10)
r.mid <- (r.max+r.min)/2

theta<-get.theta(x,fun,r=r.max,r.low=r.min)
theta.null<-get.theta.permute(x,fun,r=r.max,r.low=r.min,permutations=100)

null.ci<-apply(theta.null[,-(1:2)],1,quantile,probs=c(0.25,0.75))

plot(r.mid, theta$theta , type="l")
lines(r.mid, null.ci[1,] , lty=2)
lines(r.mid, null.ci[2,] , lty=2)

}
}
\seealso{
Other get.theta: 
\code{\link{get.theta.bootstrap}()},
\code{\link{get.theta.ci}()},
\code{\link{get.theta.typed.bootstrap}()},
\code{\link{get.theta.typed.permute}()},
\code{\link{get.theta.typed}()},
\code{\link{get.theta}()}
}
\concept{get.theta}
