% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDF.R
\name{TS.acc}
\alias{TS.acc}
\title{Accumulation of a time series}
\usage{
TS.acc(x,acc.val,moving.sum="FALSE")
}
\arguments{
\item{x}{\code{vector} of a time series}

\item{acc.val}{\code{value} specifying the accumulation level, minimum value is 2}

\item{moving.sum}{\code{logical} 'TRUE' means moving sum will be applied}
}
\value{
x.acc \code{TS.acc} returns a \code{vector} of an accumulated time series
}
\description{
\code{TS.acc} accumulates a given time series \code{x} at a given accumulation level \code{acc.val}. Minimum value
for acc.val is 2 [unit time]. Option for using moving sum is given.
}
\examples{
TS <- rgamma(n=1000,shape=1)
acc.2 <- TS.acc(TS,acc.val=2)
\donttest{
acc.24 <- TS.acc(TS,acc.val=24,moving.sum=TRUE)
}
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}

Carola Detring \email{carola.detring@met.fu-berlin.de}
}

