% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcCoxCalibRSIntsP.R
\name{CalcCoxCalibRSIntsP}
\alias{CalcCoxCalibRSIntsP}
\title{Calculating the probabilities of positive binary exposure status at a given time point using proportional hazards grouped risk-set
 calibration models}
\usage{
CalcCoxCalibRSIntsP(w, w.res, point, fit.cox.rs.ints, hz.times, Q, pts.for.ints)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. Each measurement corresponds to the time points in \code{w}}

\item{point}{The time point at which the probabilities are estimated}

\item{fit.cox.rs.ints}{The result of \code{FitCalibCoxRSInts} on the interval-censored data}

\item{hz.times}{Times used for calculating the baseline hazard function from PH calibration model}

\item{Q}{Matrix of covariates for the PH calibration model}

\item{pts.for.ints}{Points defining the intervals for grouping risk-sets (first one has to be zero). Should be sorted from zero up}
}
\value{
A vector of estimated probabilities of positive exposure status at time \code{point}.
}
\description{
For a given time point, calculate the probability of positive exposure value  for multiple observations (participants). 
The function uses the results of proportional hazards grouped risk-set calibration model fit, and given covariates and collected data on the history 
of the binary exposure for each participant.
}
\examples{
set.seed(17)
sim.data <- ICcalib:::SimCoxIntervalCensCox(n.sample = 100, lambda = 0.1, 
                                            alpha = 0.25, beta0 = 0, 
                                            gamma.q = c(log(0.75), log(2.5)), 
                                            gamma.z = log(1.5), mu = 0.2, 
                                            n.points = 2)
# The baseline hazard for the calibration model is calculated in observation times
cox.hz.times <- sort(unique(sim.data$obs.tm)) 
# Fit proprtional hazards calibration model
fit.cox.rs.ints <- FitCalibCoxRSInts(w = sim.data$w, w.res = sim.data$w.res, 
                                     Q = sim.data$Q, hz.times = cox.hz.times, 
                                     n.int = 5, order = 2, pts.for.ints = seq(0,4,1), 
                                     tm = sim.data$obs.tm, event = sim.data$delta)
# Calculate the conditional probabilities of binary covariate=1 at time one
probs <- CalcCoxCalibRSIntsP(w = sim.data$w, w.res = sim.data$w.res, point = 1,
                             fit.cox.rs.ints = fit.cox.rs.ints,
                             pts.for.ints = seq(0,4,1), Q = sim.data$Q, 
                             hz.times = cox.hz.times)
summary(probs)
}
