% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_crit.R
\name{med_crit}
\alias{med_crit}
\alias{med_crit.ICS}
\alias{med_crit.default}
\title{Selection of Invariant components using the med criterion}
\usage{
med_crit(object, ...)

\method{med_crit}{ICS}(object, nb_select = NULL, select_only = FALSE, ...)

\method{med_crit}{default}(object, nb_select = NULL, select_only = FALSE, ...)
}
\arguments{
\item{object}{object of class \code{"ICS"}.}

\item{\dots}{additional arguments are currently ignored.}

\item{nb_select}{the exact number of components to select. By default it is set to
\code{NULL}, i.e the number of components to select is the number of variables minus one.}

\item{select_only}{boolean. If \code{TRUE} only the vector names of the selected
invariant components is returned. If \code{FALSE} additional details are returned.}
}
\value{
If \code{select_only} is  \code{TRUE} a vector of the names of the invariant
components or variables to select. If \code{FALSE} an object of class \code{"ICS_crit"}
is returned with the following objects:
\itemize{
\item \code{crit}: the name of the criterion "med".
\item \code{nb_select}: the number of components to select.
\item \code{gen_kurtosis}: the vector of generalized kurtosis values.
\item \code{med_gen_kurtosis}: the median of the generalized kurtosis values.
\item \code{gen_kurtosis_diff_med}: the absolute differences between the generalized
kurtosis values and the median.
\item \code{select}: the names of the invariant components or variables to select.
}
}
\description{
Identifies as interesting invariant coordinates whose generalized eigenvalues are the furthermost away
from the median of all generalized eigenvalues.
}
\details{
If more than half of the components are "uninteresting" and have the same generalized eigenvalue then the median
of all generalized eigenvalues corresponds
to the uninteresting component generalized eigenvalue. The components of interest are the ones whose generalized eigenvalues differ
the most from the median. The motivation of this criterion depends therefore on the assumption that at least half of the
components have equal generalized eigenvalues.
}
\examples{
X <- iris[,-5]
out <- ICS(X)
med_crit(out, nb_select = 2, select_only = FALSE)
}
\references{
Alfons, A., Archimbaud, A., Nordhausen, K., & Ruiz-Gazen, A. (2022).
Tandem clustering with invariant coordinate selection.
\emph{arXiv preprint arXiv:2212.06108}..
}
\seealso{
\code{\link[=normal_crit]{normal_crit()}}, \code{\link[=var_crit]{var_crit()}}, \code{\link[=discriminatory_crit]{discriminatory_crit()}}.
}
\author{
Andreas Alfons, Aurore Archimbaud and Klaus Nordhausen
}
