% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatters.R
\name{ICS_tcov}
\alias{ICS_tcov}
\title{Pairwise one-step M-estimate of scatter for ICS}
\usage{
ICS_tcov(x, beta = 2)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{beta}{a positive numeric value specifying the tuning parameter of the
pairwise one-step M-estimator (default to 2), see \code{\link{tcov}()}.}
}
\value{
An object of class \code{"ICS_scatter"} with the following
components:
\item{location}{this is \code{NULL} as the estimator is based on pairwise
differences and does not use a location estimate.}
\item{scatter}{a numeric matrix giving the estimate of the scatter matrix.}
\item{label}{a character string providing a label for the scatter matrix.}
}
\description{
Wrapper function for the pairwise one-step M-estimator of scatter with
weights based on pairwise Mahalanobis distances, as computed by
\code{\link{tcov}()}. Note that this estimator is based on pairwise
differences and therefore no location estimate is returned.
}
\seealso{
\code{\link[ICS]{ICS}()}

\code{\link{tcov}()}, \code{\link{ucov}()}, \code{\link{ICS_ucov}()}
}
\author{
Andreas Alfons
}
