% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_loglin}
\alias{FIM_loglin}
\title{Fisher Information Matrix for the Mixed Inhibition Model}
\usage{
FIM_loglin(x, w, param)
}
\arguments{
\item{x}{Vector of design points.}

\item{w}{Vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w) = 1}.}

\item{param}{Vector of values for the model parameters \code{c(theta0, theta1, theta2)}.}
}
\value{
Fisher information matrix.
}
\description{
It provides the cpp function for the FIM for the model \code{~theta0 + theta1* log(x + theta2)}.
}
\details{
The FIM of this model does not depend on the parameter \code{theta0}.
}
\references{
Dette, H., Kiss, C., Bevanda, M., & Bretz, F. (2010). Optimal designs for the EMAX, log-linear and exponential models. Biometrika, 97(2), 513-518.
}
