% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_related_functions.R
\name{StrelkaIDVCFFilesToZipFile}
\alias{StrelkaIDVCFFilesToZipFile}
\title{Create a zip file which contains ID (small insertion and deletion) catalog
and plot PDF from Strelka ID VCF files}
\usage{
StrelkaIDVCFFilesToZipFile(
  dir,
  zipfile,
  ref.genome,
  region = "unknown",
  names.of.VCFs = NULL,
  base.filename = "",
  flag.mismatches = 0
)
}
\arguments{
\item{dir}{Pathname of the directory which contains the Strelka ID VCF files.
Each Strelka ID VCF \strong{must} have a file extension ".vcf" (case
insensitive) and share the \strong{same} \code{ref.genome} and
\code{region}.}

\item{zipfile}{Pathname of the zip file to be created.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{names.of.VCFs}{Optional. Character vector of names of the VCF files.
The order of names in \code{names.of.VCFs} should match the order of VCFs
listed in \code{dir}. If \code{NULL}(default), this function will remove
all of the path up to and including the last path separator (if any) in
\code{dir} and file paths without extensions (and the leading dot) will be
used as the names of the VCF files.}

\item{base.filename}{Optional. The base name of the CSV and PDF file to be
produced; the file is ending in \code{catID.csv} and \code{catID.pdf}
respectively.}

\item{flag.mismatches}{Optional. If > 0, then if there are mismatches to
references in the ID (insertion/deletion) VCF, generate messages showing
the mismatched rows and continue. Otherwise \code{stop} if there are
mismatched rows. See \code{\link{AnnotateIDVCF}} for more details.}
}
\value{
A list of two elements. 1st element is an S3 object containing an ID
  (small insertion and deletion) catalog with class "IndelCatalog". See
  \code{\link{as.catalog}} for more details. 2nd element is a list of further
  annotated VCFs.
}
\description{
Create ID (small insertion and deletion) catalog from the Strelka ID VCFs
specified by \code{dir}, save the catalog as CSV file, plot it to PDF and
generate a zip archive of all the output files.
}
\details{
This function calls \code{\link{StrelkaIDVCFFilesToCatalog}},
\code{\link{PlotCatalogToPdf}}, \code{\link{WriteCatalog}} and
\code{\link[zip]{zipr}}.
}
\note{
In ID (small insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation deletion
  repeat sizes range from 1 to 6+.
}
\examples{
 
dir <- c(system.file("extdata/Strelka-ID-vcf",
                     package = "ICAMS"))
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  catalogs <- 
    StrelkaIDVCFFilesToZipFile(dir, 
                               zipfile = file.path(tempdir(), "test.zip"),
                               ref.genome = "hg19", 
                               region = "genome",
                               base.filename = "Strelka-ID")
  unlink(file.path(tempdir(), "test.zip"))}
}
