\name{IBHM-package}
\alias{IBHM-package}
\alias{IBHM}
\docType{package}
\title{
Approximation using the IBHM method
}
\description{
Implementation of an incremental model construction method called IBHM which stands for Incrementally Built Heterogeneous Model. The method is designed for solving real-number approximation problems in a highly automated fashion and should be considered one of black-box modelling approaches such as Artificial
Neural Networks or Support Vector Machines. 
}
\details{
\tabular{ll}{
Package: \tab IBHM\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2013-03-21\cr
License: \tab GPL (>= 2)\cr
}
The package may be used to produce small, robust computational models using real valued empirical data. The most important functions are \code{\link{TrainIBHM}} which constructs an IBHM model and \code{\link{ConfigureIBHM}}
which sets the methods parameters.
}
\author{
Pawel Zawistowski

Maintainer: Pawel Zawistowski <dratewka@gmail.com>
}
\references{
Zawistowski, P. and Arabas, J.: "Benchmarking IBHM method using NN3 competition dataset." In \emph{Proc. 6th int. conf.  on Hybrid artificial intelligent systems} - Vol. 1, HAIS'11, pp 263--270, 2011. Springer-Verlag.
}

\keyword{ package }
\keyword{ ~models }
\keyword{ ~regression }
\keyword{ ~nonlinear }

