% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_HYDRO2.R
\name{GetEstimate_HYDRO2}
\alias{GetEstimate_HYDRO2}
\title{Hydro2 estimate of a distribution}
\usage{
GetEstimate_HYDRO2(y, dist)
}
\arguments{
\item{y}{numeric vector, data}

\item{dist}{character, distribution name}
}
\value{
A list with the following components:
    \item{par}{numeric vector, estimated parameter vector.}
    \item{obj}{numeric, objective fonction (NA for this estimate)}
    \item{ok}{logical, did computation succeed?}
    \item{err}{integer, error code (0 if ok)}
    \item{message}{error message}
}
\description{
Returns an estimate of a distribution as it was computed in the old HYDRO2 software.
Only available for distributions 'Normal', 'LogNormal', and 'Gumbel'.
}
\examples{
y=c(9.2,9.5,11.4,9.5,9.4,9.6,10.5,11.1,10.5,10.4)
GetEstimate_HYDRO2(y,'Normal')
GetEstimate_HYDRO2(y,'LogNormal')
GetEstimate_HYDRO2(y,'Gumbel')
GetEstimate_HYDRO2(y,'GEV')
GetEstimate_HYDRO2(y,'Poisson')
}
