\name{generateTree}
\alias{generateTree}
\title{Generate Test Trees}
\description{This function will take a base tree and will randomly populate a new tree based on the base tree.}
\usage{
generateTree(data = NULL, maxScore = 7000, equalProb = TRUE, 
setProbs)
}

\arguments{
  \item{data}{A data set that contains 1 column containing the taxa levels and at least 1 column of values for those levels.}
  \item{maxScore}{The maximum number of reads the created a tree will contain.}
  \item{equalProb}{When 'TRUE' all children nodes have an equal chance at being selected,
  	When 'FALSE' the probability is based on the given values for each child.}
  \item{setProbs}{A vector of probabilities to be applied to the 2nd level (generally phylum) (See Details).}
}
\details{
A tree is generated by using the 'sample' function using either equal probabilities when 'equalProb' is 'TRUE' or the weighted probabilities when
'FALSE' for every taxanomical level.  Essential what is done is the new tree is started at the top level and one random child is selected, then
another random child is selected from that node, and so forth until a level without children is reached. This is repeated 'maxScore' times with a
value of 1 being added to the value of the selected nodes in the new tree, each time a node is selected. 

When setProbs is given: the existing 2nd level taxa are found and ranked in order from most prevalent to least, 
then the probabilities in setProbs are applied to the existing 2nd level taxa in that order.  If setProbs contains less 
probabilities than those that exist the rest are set to 0.}

\value{A single generated tree.}
\author{Patricio S. La Rosa, Elena Deych, Berkley Shands, William D. Shannon}

\examples{
data(saliva)

### Get the MLE of the saliva data as our base tree
salivaMLE <- getMLEandLoglike(saliva)$mleTree

### Generate 2 trees based on the MLE of saliva
genData <- salivaMLE[1]
for(i in 1:2){
	genData <- cbind(genData, generateTree(salivaMLE, 7000, 
	setProbs=c(.33, .33, .33))[2])
}
colnames(genData) <- c("taxa", 2:ncol(genData))
}