% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmm.smoother.R
\name{hmm.smoother}
\alias{hmm.smoother}
\title{Smoother recursion over filtered state estimates}
\usage{
hmm.smoother(f, K1, K2, L, P)
}
\arguments{
\item{f}{is array output from \code{hmm.filter}}

\item{K1}{is movement kernel generated by \code{gausskern} for behavior state
1}

\item{K2}{is movement kernel generated by \code{gausskern} for behavior state
2}

\item{L}{is likelihood array output from \code{make.L}}

\item{P}{is transition matrix (usually 2x2) representing probability of state
switching}
}
\value{
an array of the final state estimates of dim(state, time, lon, lat)
}
\description{
\code{hmm.smoother} provides backward (starting at end) recursion over 
filtered state estimates as output from \code{hmm.filter}. The product of 
this function an array containing final state estimates.
}
\examples{
\dontrun{
# Not run as function relies on large arrays of likelihoods
# RUN THE SMOOTHING STEP
s <- hmm.smoother(f, K1, K2, L, P.final)
}

}
\references{
Pedersen MW, Patterson TA, Thygesen UH, Madsen H (2011)
  Estimating animal behavior and residency from movement data. Oikos
  120:1281-1290. doi: 10.1111/j.1600-0706.2011.19044.x
}
