% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readHMD.R
\name{readJMDweb}
\alias{readJMDweb}
\title{read data from the Japan Mortality Database into R}
\usage{
readJMDweb(prefID = "01", item = "Deaths_5x5", fixup = TRUE, ...)
}
\arguments{
\item{prefID}{a single prefID 2-digit character string, ranging from \code{"00"} to \code{"47"}.}

\item{item}{the statistical product you want, e.g., \code{"fltper_5x5"}. Only 1.}

\item{fixup}{logical. Should columns be made more user-friendly, e.g., forcing Age to be integer?}

\item{...}{extra arguments ultimately passed to \code{read.table()}. Not likely needed.}
}
\value{
\code{data.frame} of the data item is invisibly returned
}
\description{
JMD data are formatted exactly as HMD data. This function simply parses the necessary url together given a prefecture code and data item (same nomenclature as HMD). Data is parsed using \code{HMDparse()}, which converts columns into useful and intuitive classes, for ready-use. See \code{?HMDparse} for more information on type conversions. No authentification is required for this database. Only a single item/prefecture is downloaded. Loop for more complex calls (See examples). The prefID is not appended as a column, so be mindful of this if appending several items together into a single \code{data.frame}. Note that at the time of this writing, the finest Lexis resolution for prefectural lifetables is 5x5 (5-year, 5-year age groups). Raw data are, however, provided in 1x1 format, and deaths are also available in triangles.
}
\details{


No details of note. This database in independently maintained, so file types/locations are subject to change. If this happens, please notify the package maintainer.
}
\examples{
\dontrun{
library(HMDHFDplus)
# grab prefecture codes (including All Japan)
prefectures <- getJMDprefectures()
# grab all mltper_5x5
# and stick into long data.frame:
mltper <- do.call(rbind, lapply(prefectures, function(prefID){
                   Dat        <- readJMDweb(prefID = prefID, item = "mltper_5x5", fixup = TRUE)
                   Dat$PrefID <- prefID
                   Dat
}))
}
}

