% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchandBuildAlignments.R
\name{uniAlign}
\alias{uniAlign}
\title{Generate an Alignment for Specific Alleles at Specific Positions}
\usage{
uniAlign(alignType, alleles, positions)
}
\arguments{
\item{alignType}{The type of alignment being searched. Allowed values are "prot", codon", "nuc" and "gen". Only one 'alignType' value is allowed.}

\item{alleles}{A vector of un-prefixed HLA locus names.}

\item{positions}{A vector of codon positions, against which all loci will be aligned.}
}
\value{
A data frame of allele names and the corresponding codon sequence for specified position. a codon sequence is not returned for a specific allele if input allele is not available in the ANHIG/IMGTHLA Github Repository. position will be left empty if specific allele does not have a codon at the input position.
}
\description{
Generates a peptide, codon, coding or genomic nucleotide alignment at a single set of positions for HLA alleles at one or more loci.
}
\note{
For internal HLAtools use.
}
