% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robot_indexes_df.R
\name{robot_indexes_df}
\alias{robot_indexes_df}
\title{Returns dataframe with peptides which exhibit significant difference between two sets}
\usage{
robot_indexes_df(thP, th, replicates = 3, pvalue = 0.01, states, CI_factor = 1)
}
\arguments{
\item{thP}{output of output_tcourse_proc() function. Raw data for procent deuteration for time courses}

\item{th}{output of output_tcourse() function. Raw data for uptake deuteration for time courses}

\item{replicates}{number of replicates in sample. Default set to 3.}

\item{pvalue}{p-value cutoff. Default set up to 0.01}

\item{states}{Protein states from the set. As default all states are chosen.}

\item{CI_factor}{Multiplication factor for Critical Interval. Allows for more restrictive selection of Critial interval.}
}
\value{
Returns dataframe listing peptides that are significantly different between sets.
}
\description{
Function to help decide which peptides will be drawn on Robot plots.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
tm_df<-output_tc(filepath=file_nm)
tmP_df<-output_tc(filepath=file_nm, percent=TRUE)

# more restictive peptide selection
robot_indexes_df(thP = tmP_df, th=tm_df, pvalue=0.001, CI_factor=3)
}
