% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rerandomization_search.R
\name{initRerandomizationExperimentalDesignObject}
\alias{initRerandomizationExperimentalDesignObject}
\title{This method creates an object of type rerandomization_experimental_design and will immediately initiate
a search through $1_{T}$ space.}
\usage{
initRerandomizationExperimentalDesignObject(X, max_designs = 1000,
  obj_val_cutoff_to_include = NULL, objective = "mahal_dist",
  wait = FALSE, start = TRUE, num_cores = 1)
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{max_designs}{The maximum number of designs to be returned. Default is 10,000. Make this large 
so you can search however long you wish as the search can be stopped at any time by
using the \code{\link{stopSearch}} method}

\item{obj_val_cutoff_to_include}{Only allocation vectors with objective values lower than this threshold will be returned.
The default is \code{NULL} which means all vectors are returned.}

\item{objective}{The objective function to use when searching the design space. This is a string
"\code{abs_sum_diff}" (default) or "\code{mahal_dist}."}

\item{wait}{Should the \code{R} terminal hang until all \code{max_designs} vectors are found? The 
default is \code{FALSE}.}

\item{start}{Should we start searching immediately (default is \code{TRUE}).}

\item{num_cores}{The number of CPU cores you wish to use during the search. The default is \code{1}.}
}
\value{
An object of type \code{rerandomization_experimental_design_search} which can be further operated upon.
}
\description{
This method creates an object of type rerandomization_experimental_design and will immediately initiate
a search through $1_{T}$ space.
}
\author{
Adam Kapelner
}

